package net.aihelp.ui.webkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.utils.TLog;

import androidx.annotation.NonNull;

public class AIHelpWebView extends WebView {

    public AIHelpWebView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.configureWebView();
        }
    }

    public AIHelpWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.configureWebView();
        }
    }

    @SuppressLint("SetJavaScriptEnabled")
    private void configureWebView() {
        WebSettings settings = this.getSettings();
        settings.setCacheMode(WebSettings.LOAD_DEFAULT);
        settings.setJavaScriptEnabled(true);
        settings.setGeolocationEnabled(true);
        settings.setUseWideViewPort(true);
        settings.setJavaScriptCanOpenWindowsAutomatically(true);
        settings.setSupportZoom(true);
        settings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);
        settings.setPluginState(WebSettings.PluginState.ON);
        settings.setUserAgentString(settings.getUserAgentString() + "Rong/2.0");
        settings.setLoadWithOverviewMode(true);
        settings.setBlockNetworkImage(false);
        settings.setAllowFileAccess(true);
        settings.setDomStorageEnabled(true);
        settings.setDatabaseEnabled(true);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec, MeasureSpec.makeMeasureSpec(Integer.MAX_VALUE >> 2, MeasureSpec.AT_MOST));
//
//        super.onMeasure(widthMeasureSpec, MeasureSpec.makeMeasureSpec(500, MeasureSpec.AT_MOST));
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void loadUrl(@NonNull String url) {
        super.loadUrl(url);
//        TLog.d("AIHelpWebView", "开始 --- " + url);
//        EventTracker.INSTANCE.log(EventType.CS_CLICK_URL, url);

    }

}
