package net.aihelp.ui.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;

import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.HideAttachmentMenuEvent;
import net.aihelp.utils.KeyboardChangeHelper;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.TLog;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

public class AIHelpChatRecyclerView extends RecyclerView {

    public AIHelpChatRecyclerView(@NonNull Context context) {
        super(context);
    }

    public AIHelpChatRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public AIHelpChatRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

//    @Override
//    protected void onAttachedToWindow() {
//        super.onAttachedToWindow();
//
//        addOnScrollListener(new OnScrollListener() {
//            @Override
//            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
//                super.onScrolled(recyclerView, dx, dy);
//                if (dy < 0 && KeyboardChangeHelper.isKeyboardShown(recyclerView)) {
//                    SoftInputUtil.hideSoftInput(getContext(), AIHelpChatRecyclerView.this);
//                }
//            }
//        });
//
//    }

    @Override
    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == MotionEvent.ACTION_DOWN) {
            EventBus.getDefault().post(new HideAttachmentMenuEvent());
            if (KeyboardChangeHelper.isKeyboardShown(this)) {
                SoftInputUtil.hideSoftInput(getContext(), AIHelpChatRecyclerView.this);
            }
        }
        return super.dispatchTouchEvent(ev);
    }

}
