package net.aihelp.ui.widget;

import android.animation.LayoutTransition;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

//import net.aihelp.core.ui.glide.Glide;
//import net.aihelp.core.ui.glide.RequestBuilder;
//import net.aihelp.core.ui.glide.load.engine.DiskCacheStrategy;
//import net.aihelp.core.ui.glide.load.resource.bitmap.RoundedCorners;
//import net.aihelp.core.ui.glide.request.RequestOptions;
//import net.aihelp.core.ui.glide.request.target.SimpleTarget;
//import net.aihelp.core.ui.glide.request.transition.Transition;


import net.aihelp.core.ui.glide.Glide;

import net.aihelp.core.ui.loading.indicator.LoadingIndicatorView;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;

public class AIHelpLoadingImageView extends FrameLayout {

    private AppCompatImageView imageView;
    private AppCompatImageView ivPlay;
    private View maskView;
    private LoadingIndicatorView loadingView;

    private boolean isVideo;

    private boolean isLoading;

    public boolean isLoading() {
        return isLoading;
    }

    public void setLoading(boolean loading) {
        isLoading = loading;
    }

    public boolean isVideo() {
        return isVideo;
    }

    public void setVideo(boolean video) {
        isVideo = video;
    }

    public AppCompatImageView getRealImageView() {
        return imageView;
    }

    public AIHelpLoadingImageView(@NonNull Context context) {
        super(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        getAttributes(context, attrs);
        init(context);
    }

    public AIHelpLoadingImageView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        getAttributes(context, attrs);
        init(context);
    }

    private void getAttributes(Context context, AttributeSet attrs) {
        int[] styleable = ResResolver.getStyleable("aihelp_widget");
        if (styleable != null) {
            TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, styleable, 0, 0);
            isVideo = ta.getBoolean(ResResolver.getStyleableFieldIndex("aihelp_widget",
                    "aihelp_widget_is_video"), false);
            ta.recycle();
        }
    }

    private void init(Context context) {
        setLayoutTransition(new LayoutTransition());
        setBackground(AppCompatResources.getDrawable(context, ResResolver.getDrawableId("aihelp_bg_uploading_mask")));
        setForegroundGravity(Gravity.CENTER);

        View rootView = inflate(context, ResResolver.getLayoutId("aihelp_loading_image_view"), this);
        imageView = rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        ivPlay = rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        loadingView = rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        updateLoadingStatus(true);
    }

    public void resetStatus() {
        ViewGroup.LayoutParams layoutParams = getLayoutParams();
        layoutParams.width = Styles.dpToPx(getContext(), 100);
        layoutParams.height = Styles.dpToPx(getContext(), 150);
        setLayoutParams(layoutParams);
        updateLoadingStatus(true);
    }

    public void updateLoadingStatus(boolean showLoading) {
        maskView.setVisibility(showLoading ? VISIBLE : GONE);
        loadingView.setVisibility(showLoading ? VISIBLE : GONE);
        if (isVideo) {
            ivPlay.setVisibility(showLoading ? GONE : VISIBLE);
        }
        setLoading(showLoading);
    }

    public void loadIntoImageView(final Context context, final FileMessage message) {
        if (context instanceof Activity && !((Activity) context).isFinishing()) {
            final String loadSource = DomainSupportHelper.getAdjustedUrl(
                    isVideo ? message.getVideoThumbnail() : message.getContent()
            );

            // If the image view has been rendered before, the reused view's imageSize will be non-null,
            // then we can load this view directly since we have the image size info already.
            // Do not forget to update loading status in this case, or the mask view can't be removed properly.
            if (message.getImageSize() != null) {
                Glide.with(getContext()).load(loadSource).into(imageView);
                ViewGroup.LayoutParams rootLayoutParams = AIHelpLoadingImageView.this.getLayoutParams();
                ViewGroup.LayoutParams params = imageView.getLayoutParams();
                rootLayoutParams.width = params.width = message.getImageSize()[0];
                rootLayoutParams.height = params.height = message.getImageSize()[1];
                setLayoutParams(rootLayoutParams);
                imageView.setLayoutParams(params);
                updateLoadingStatus(false);
                return;
            }

            resetStatus();
            MediaUtils.scaleImageView(loadSource, imageView, this, new MediaUtils.OnImageScaledListener() {
                @Override
                public void onImageScaled() {
                    if (message.getImageSize() == null) {
                        ViewGroup.LayoutParams params = AIHelpLoadingImageView.this.getLayoutParams();
                        int[] size = new int[2];
                        size[0] = params.width;
                        size[1] = params.height;
                        message.setImageSize(size);
                    }
                    // reset the loading status after the imageSize is prepared
                    updateLoadingStatus(false);
                }
            });

        }
    }

    public int dip2px(Context context, double dpValue) {
        float density = context.getResources().getDisplayMetrics().density;
        return (int) (dpValue * density + 0.5);
    }

    public void showPlayButton(boolean show) {
        ivPlay.setVisibility(show ? VISIBLE : GONE);
    }

}
