package net.aihelp.utils;

import android.text.TextUtils;

import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;

import java.util.Timer;
import java.util.TimerTask;

public enum DebounceHelper {

    INSTANCE;

    private Timer debounceTimer;

    public void debounceAsync(Runnable runnable) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable() {
            @Override
            public void run() {
                debounce(runnable, 500);
            }
        });
    }

    public void debounce(Runnable runnable) {
        debounce(runnable, 500);
    }

    public void debounceAsync(Runnable runnable, int delay) {
        ApiExecutorFactory.getHandlerExecutor().runAsync(new Runnable() {
            @Override
            public void run() {
                debounce(runnable, delay);
            }
        });
    }

    public void debounce(Runnable runnable, int delay) {
        resetTimer();
        debounceTimer = new Timer();
        debounceTimer.schedule(new TimerTask() {
            @Override
            public void run() {
                if (debounceTimer != null && runnable != null) {
                    runnable.run();
                }
            }
        }, delay);
    }

    public void resetTimer() {
        if (debounceTimer != null) {
            debounceTimer.cancel();
        }
    }

}