package net.aihelp.utils;

import android.text.TextUtils;

import java.util.regex.Pattern;

public class RegexUtil {

    public static final String AIHELP_SUPPORTED_IMAGE = "(?i).+\\.(png|jpg|jpeg|gif|heic|bmp)$";
    public static final String AIHELP_SUPPORTED_VIDEO = "(?i).+\\.(mp4|avi|3gp|mov|mpeg|mpg|m4v|webm|mkv|rmvb|mov|wmv|flv)$";

    public static final String ANDROID_SUPPORTED_IMAGE = "(?i).+\\.(png|jpg|jpeg|gif)$";
    public static final String ANDROID_SUPPORTED_VIDEO = "(?i).+\\.(mp4|3gp|mkv|webm)$";

    public static final String ANDROID_SUPPORTED_IMAGE_SUFFIX = "(?i)(png|jpg|jpeg|gif)";
    public static final String ANDROID_SUPPORTED_VIDEO_SUFFIX = "(?i)(mp4|3gp|mkv|webm)";

    public static final String REGEX_IMAGE = "(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)";
    public static final String REGEX_VIDEO = "(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)";
    public static final String REGEX_RICH_TEXT = "(?i)(https?://\\S*?((?=\\s+http)|\\.(png|jpg|jpeg|gif|mp4|3gp|mkv|webm))|https?://((?!\").)*)";

    public static boolean isVideoFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            return Pattern.compile(RegexUtil.ANDROID_SUPPORTED_VIDEO).matcher(filePath).matches();
        }
        return false;
    }

    public static boolean isImageFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            return Pattern.compile(RegexUtil.ANDROID_SUPPORTED_IMAGE).matcher(filePath).matches();
        }
        return false;
    }

    public static boolean isGifFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            return filePath.endsWith("gif") || filePath.endsWith("GIF");
        }
        return false;
    }

    public static boolean isLocalMediaFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            boolean isLocalPath = filePath.startsWith("/");
            boolean isImageFile = Pattern.compile(RegexUtil.ANDROID_SUPPORTED_IMAGE).matcher(filePath).matches();
            boolean isVideoFile = Pattern.compile(RegexUtil.ANDROID_SUPPORTED_VIDEO).matcher(filePath).matches();
            return isLocalPath && (isImageFile || isVideoFile);
        }
        return false;
    }

    public static boolean isLocalFile(String filePath) {
        if (!TextUtils.isEmpty(filePath)) {
            return filePath.startsWith("/");
        }
        return false;
    }

    public static boolean isMatch(String filePath, String regExp) {
        if (TextUtils.isEmpty(filePath) || TextUtils.isEmpty(regExp)) {
            return false;
        }
        return Pattern.compile(regExp).matcher(filePath).matches();
    }

    public static boolean isRegexValid(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        } catch (Exception e) {
            return false;
        }
    }
}
