package net.aihelp.utils;

import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.UploadCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.init.UploadEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.File;
import java.util.regex.Pattern;

public enum UploadFileHelper {

    INSTANCE;

    private OnUploadFileListener onUploadFileListener;

    public UploadFileHelper setOnUploadFileListener(OnUploadFileListener onUploadFileListener) {
        this.onUploadFileListener = onUploadFileListener;
        return this;
    }

    public void tryUploadLog(boolean isUploadLog) {
        // Enable the fetch-message request after user submitted a ticket
        Const.TOGGLE_FETCH_MESSAGE = true;
        if (isUploadLog && Const.TOGGLE_UPLOAD_LOG && !TextUtils.isEmpty(Const.LOG_UPLOAD_PATH)) {
            File file = new File(Const.LOG_UPLOAD_PATH);
            if (file.exists() && !file.isDirectory()) {
                String fileName = file.getName();
                if (!TextUtils.isEmpty(fileName)) {
                    AIHelpRequest.getInstance().requestUpLoadFile(API.UPLOAD_LOG_URL, file, new UploadCallback<String>() {
                        @Override
                        public void onReqSuccess(String result) {
                            try {
                                JSONArray jsonArray = new JSONArray();
                                jsonArray.put(JsonHelper.optString(new JSONObject(result), "data"));
                                AIHelpRequest.getInstance().requestPostByJson(API.UPLOAD_LOG, jsonArray.toString(), null);
                            } catch (Exception e) {
                                // ignored
                            }
                        }
                    });
                }
            }
        }
    }

    public void performUpload(File file) {
        if (file == null) return;
        String filePath = file.getPath();
        AIHelpRequest.getInstance().requestUpLoadFile(getUploadUrl(filePath), file, new UploadCallback<String>() {
            @Override
            public void onReqSuccess(String result) {
                if (!TextUtils.isEmpty(result)) {
                    String fileUrl = getUploadResult(filePath, result);
                    if (onUploadFileListener != null) {
                        onUploadFileListener.onFileUploaded(fileUrl);
                    }
                }
            }

            @Override
            public void onFailure(String url, int errorCode, String errorMsg) {
                if (onUploadFileListener != null) {
                    onUploadFileListener.onFileUploaded("");
                }
            }
        });
    }

    private String getUploadUrl(String filePath) {
        if (Pattern.compile(RegexUtil.AIHELP_SUPPORTED_IMAGE).matcher(filePath).matches()) {
            return API.UPLOAD_IMAGE_URL;
        }
        if (Pattern.compile(RegexUtil.AIHELP_SUPPORTED_VIDEO).matcher(filePath).matches()) {
            return API.UPLOAD_VIDEO_URL;
        }
        if (filePath.contains("/AIHelp/event/")) {
            return API.UPLOAD_SAMPLING_URL;
        }
        return API.UPLOAD_ATTACHMENT_URL;
    }

    private String getUploadResult(String filePath, String result) {
        if (Pattern.compile(RegexUtil.AIHELP_SUPPORTED_IMAGE).matcher(filePath).matches()) {
            UploadEntity.ImageResult imageResult = JsonHelper.toJavaObject(result, UploadEntity.ImageResult.class);
            if (imageResult != null && !TextUtils.isEmpty(imageResult.getUrl())) {
                return imageResult.getUrl();
            }
        } else {
            UploadEntity.FileResult fileResult = JsonHelper.toJavaObject(result, UploadEntity.FileResult.class);
            if (fileResult != null && !TextUtils.isEmpty(fileResult.getData())) {
                return fileResult.getData();
            }
        }
        return "";
    }

    public interface OnUploadFileListener {
        void onFileUploaded(String fileUrl);
    }

}
