/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.config;

import net.aihelp.core.net.json.JsonHelper;
import org.json.JSONObject;

public class ApiConfig {
    private final String entranceId;
    private final String welcomeMessage;

    public String getWelcomeMessage() {
        return this.welcomeMessage;
    }

    public String getEntranceId() {
        return this.entranceId;
    }

    public ApiConfig(String entranceId, String welcomeMessage) {
        this.entranceId = entranceId;
        this.welcomeMessage = welcomeMessage;
    }

    public JSONObject desc() {
        JSONObject jsonObject = JsonHelper.getJsonObject();
        JsonHelper.put(jsonObject, "entranceId", this.entranceId);
        JsonHelper.put(jsonObject, "welcomeMessage", this.welcomeMessage);
        return jsonObject;
    }

    public static class Builder {
        private String entranceId;
        private String welcomeMessage;

        public Builder setEntranceId(String entranceId) {
            this.entranceId = entranceId;
            return this;
        }

        public Builder setWelcomeMessage(String welcomeMessage) {
            this.welcomeMessage = welcomeMessage;
            return this;
        }

        public ApiConfig build(String entranceId, String welcomeMessage) {
            return new ApiConfig(entranceId, welcomeMessage);
        }

        public ApiConfig build() {
            return new ApiConfig(this.entranceId, this.welcomeMessage);
        }
    }
}

