/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.config;

import android.text.TextUtils;
import net.aihelp.config.ConversationConfig;

public class OperationConfig {
    private int selectIndex;
    private String conversationTitle;
    private ConversationConfig conversationConfig;

    public int getSelectIndex() {
        return this.selectIndex;
    }

    public String getConversationTitle() {
        return this.conversationTitle;
    }

    public ConversationConfig getConversationConfig() {
        return this.conversationConfig;
    }

    private OperationConfig(int selectIndex, String conversationTitle, ConversationConfig conversationConfig) {
        this.selectIndex = selectIndex;
        this.conversationTitle = conversationTitle;
        this.conversationConfig = conversationConfig;
    }

    public String toString() {
        return "OperationConfig{selectIndex=" + this.selectIndex + ", supportBotTitle='" + this.conversationTitle + '\'' + ", supportConfig=" + this.conversationConfig + '}';
    }

    public static class Builder {
        private int selectIndex = Integer.MAX_VALUE;
        private String conversationTitle;
        private ConversationConfig conversationConfig = new ConversationConfig.Builder().build();

        public Builder setSelectIndex(int selectIndex) {
            if (selectIndex < 0) {
                selectIndex = Integer.MAX_VALUE;
            }
            this.selectIndex = selectIndex;
            return this;
        }

        public Builder setConversationTitle(String conversationTitle) {
            if (!TextUtils.isEmpty((CharSequence)conversationTitle)) {
                this.conversationTitle = conversationTitle;
            }
            return this;
        }

        public Builder setConversationConfig(ConversationConfig conversationConfig) {
            this.conversationConfig = conversationConfig;
            return this;
        }

        public OperationConfig build(int selectIndex, String conversationTitle, ConversationConfig conversationConfig) {
            return this.setSelectIndex(selectIndex).setConversationTitle(conversationTitle).setConversationConfig(conversationConfig).build();
        }

        public OperationConfig build() {
            return new OperationConfig(this.selectIndex, this.conversationTitle, this.conversationConfig);
        }
    }
}

