/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class FileProgressRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 2048;
    protected File file;
    protected ProgressListener listener;
    private MediaType mediaType;

    public FileProgressRequestBody(MediaType mediaType, File file, ProgressListener listener) {
        this.mediaType = mediaType;
        this.file = file;
        this.listener = listener;
    }

    public long contentLength() {
        return this.file.length();
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            long read;
            source = Okio.source((File)this.file);
            long transferred = 0L;
            while ((read = source.read(sink.buffer(), 2048L)) != -1L) {
                transferred += read;
                sink.flush();
                if (this.listener == null) continue;
                this.listener.onProgress((int)(transferred * 100L / this.contentLength()), transferred == this.contentLength());
            }
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    public static interface ProgressListener {
        public void onProgress(int var1, boolean var2);
    }
}

