/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.interceptor;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.util.regex.Pattern;
import net.aihelp.common.Const;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONObject;

public class HeaderInterceptor
implements Interceptor {
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.isUniqueRequest(request.url().toString())) {
            return chain.proceed(request);
        }
        try {
            RequestBody requestBody = request.body();
            if (request.method().equals("GET")) {
                String sUrl = request.url().toString();
                if (!(Pattern.matches(".+\\.(ini|json|aiml|jpg|JPG|png|PNG|mp4|MP4)", sUrl) || sUrl.contains("AIML") || sUrl.contains("FAQ") || sUrl.contains("OPerMode"))) {
                    int index = sUrl.indexOf("?");
                    sUrl = index > 0 ? sUrl + "&" : sUrl + "?";
                    sUrl = sUrl + this.getAppendedParams();
                    request = request.newBuilder().url(sUrl).build();
                }
            } else if (request.method().equals("POST")) {
                if (requestBody instanceof FormBody) {
                    FormBody.Builder builder = new FormBody.Builder();
                    FormBody formBody = (FormBody)requestBody;
                    for (int i = 0; i < formBody.size(); ++i) {
                        builder.addEncoded(formBody.encodedName(i), formBody.encodedValue(i));
                    }
                    builder.addEncoded("appId", Const.APP_ID);
                    builder.addEncoded("lan", Const.CORRECT_LANGUAGE);
                    builder.addEncoded("l", Const.CORRECT_LANGUAGE);
                    builder.addEncoded("platform", String.valueOf(2));
                    builder.addEncoded("sdkVersion", "4.6.0");
                    builder.addEncoded("sdkVersionDetail", "4.6.0");
                    request = request.newBuilder().post((RequestBody)builder.build()).build();
                    return chain.proceed(request);
                }
                MediaType mediaType = null;
                if (request.body() != null) {
                    mediaType = request.body().contentType();
                }
                if (mediaType != null && "json".equals(mediaType.subtype())) {
                    String postJson = this.bodyToString(request.body());
                    if (!TextUtils.isEmpty((CharSequence)postJson)) {
                        try {
                            new JSONArray(postJson);
                        }
                        catch (Exception e) {
                            JSONObject jsonObject = new JSONObject(postJson);
                            jsonObject.put("appId", (Object)Const.APP_ID);
                            jsonObject.put("lan", (Object)Const.CORRECT_LANGUAGE);
                            jsonObject.put("l", (Object)Const.CORRECT_LANGUAGE);
                            jsonObject.put("platform", 2);
                            jsonObject.put("sdkVersion", (Object)"4.6.0");
                            jsonObject.put("sdkVersionDetail", (Object)"4.6.0");
                            RequestBody newBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonObject.toString());
                            request = request.newBuilder().post(newBody).build();
                        }
                    }
                } else {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", (Object)Const.APP_ID);
                    jsonObject.put("lan", (Object)Const.CORRECT_LANGUAGE);
                    jsonObject.put("l", (Object)Const.CORRECT_LANGUAGE);
                    jsonObject.put("platform", 2);
                    jsonObject.put("sdkVersion", (Object)"4.6.0");
                    jsonObject.put("sdkVersionDetail", (Object)"4.6.0");
                    RequestBody newBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonObject.toString());
                    request = request.newBuilder().post(newBody).build();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chain.proceed(request);
    }

    private String getAppendedParams() {
        return String.format("appId=%s&l=%s&lan=%s&platform=%s&sdkVersion=%s&sdkVersionDetail=%s", Const.APP_ID, Const.CORRECT_LANGUAGE, Const.CORRECT_LANGUAGE, 2, "4.6.0", "4.6.0");
    }

    private String bodyToString(RequestBody request) {
        try {
            Buffer buffer = new Buffer();
            if (request == null) {
                return "";
            }
            request.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "";
        }
    }

    private boolean isUniqueRequest(String url) {
        return false;
    }
}

