/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.http.interceptor;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.config.HttpConfig;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONObject;

public class SignInterceptor
implements Interceptor {
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request.Builder newBuilder = request.newBuilder();
        long timestamp = System.currentTimeMillis();
        String nonce = UUID.randomUUID().toString();
        try {
            if (request.method().equals("GET")) {
                String url = request.url().toString();
                if (!Pattern.matches("^/.+\\.(ini|json|aiml)$", url)) {
                    String sign = this.getRequestSign(this.getParamDictionary(url, timestamp, nonce));
                    request = this.addHeaders(newBuilder, timestamp, nonce, sign).url(url).build();
                }
            } else if (request.method().equals("POST")) {
                RequestBody requestBody = request.body();
                if (requestBody instanceof FormBody) {
                    FormBody formBody = (FormBody)requestBody;
                    String sign = this.getRequestSign(this.getParamDictionary(formBody, timestamp, nonce));
                    request = this.addHeaders(newBuilder, timestamp, nonce, sign).post(requestBody).build();
                    return chain.proceed(request);
                }
                MediaType mediaType = null;
                if (requestBody != null) {
                    mediaType = request.body().contentType();
                }
                if (mediaType != null && "json".equals(mediaType.subtype())) {
                    String postJson = this.bodyToString(request.body());
                    if (!TextUtils.isEmpty((CharSequence)postJson)) {
                        try {
                            new JSONArray(postJson);
                        }
                        catch (Exception e) {
                            JSONObject jsonObject = new JSONObject(postJson);
                            String sign = this.getRequestSign(this.getParamDictionary(jsonObject, timestamp, nonce));
                            request = this.addHeaders(newBuilder, timestamp, nonce, sign).post(requestBody).build();
                        }
                    }
                } else {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("appId", (Object)Const.APP_ID);
                    jsonObject.put("appkey", (Object)Const.APP_KEY);
                    jsonObject.put("lan", (Object)Const.CORRECT_LANGUAGE);
                    jsonObject.put("l", (Object)Const.CORRECT_LANGUAGE);
                    jsonObject.put("platform", 2);
                    jsonObject.put("sdkVersion", (Object)"4.6.0");
                    String sign = this.getRequestSign(this.getParamDictionary(jsonObject, timestamp, nonce));
                    request = this.addHeaders(newBuilder, timestamp, nonce, sign).post(requestBody).build();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return chain.proceed(request);
    }

    private String getPostRawString(Object obj) {
        StringBuilder result = new StringBuilder();
        if (obj instanceof FormBody) {
            FormBody formBody = (FormBody)obj;
            for (int i = 0; i < formBody.size(); ++i) {
                result.append(formBody.encodedName(i)).append("=").append(formBody.encodedValue(i)).append("&");
            }
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)obj;
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                result.append(key).append("=").append(jsonObject.opt(key)).append("&");
            }
        }
        return result.toString();
    }

    private Map<String, Object> getParamDictionary(Object obj, long timestamp, String nonce) {
        TreeMap<String, Object> sortedMap = new TreeMap<String, Object>();
        try {
            sortedMap.put("timestamp", String.valueOf(timestamp));
            sortedMap.put("nonce", nonce);
            if (obj instanceof String) {
                String[] params;
                String requestUrl = (String)obj;
                for (String param : params = requestUrl.substring(requestUrl.indexOf("?") + 1).split("&")) {
                    String[] split;
                    if (TextUtils.isEmpty((CharSequence)param) || (split = param.split("=")).length <= 0) continue;
                    sortedMap.put(split[0], split.length == 2 ? split[1] : "");
                }
            }
            if (obj instanceof FormBody) {
                FormBody formBody = (FormBody)obj;
                for (int i = 0; i < formBody.size(); ++i) {
                    sortedMap.put(formBody.encodedName(i), formBody.encodedValue(i));
                }
            }
            if (obj instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)obj;
                Iterator keys = jsonObject.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    sortedMap.put(key, jsonObject.opt(key));
                }
            }
            if (!sortedMap.containsKey("appkey")) {
                sortedMap.put("appkey", Const.APP_KEY);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortedMap;
    }

    private Request.Builder addHeaders(Request.Builder originBuilder, long timestamp, String nonce, String sign) throws UnsupportedEncodingException {
        return originBuilder.addHeader("appkey", Const.APP_KEY).addHeader("nonce", nonce).addHeader("appId", Const.APP_ID).addHeader("userId", URLEncoder.encode(UserProfile.USER_ID, "utf-8")).addHeader("timestamp", String.valueOf(timestamp)).addHeader("sign", sign);
    }

    private String getRequestSign(Map<String, Object> paramDictionary) {
        int i = 0;
        StringBuilder rawStrBuilder = new StringBuilder();
        for (String key : paramDictionary.keySet()) {
            Object value = paramDictionary.get(key);
            if (i > 0) {
                rawStrBuilder.append("&");
            }
            rawStrBuilder = rawStrBuilder.append(key).append("=");
            if (value instanceof String) {
                try {
                    rawStrBuilder.append(URLDecoder.decode(String.valueOf(value)));
                }
                catch (Exception e) {
                    rawStrBuilder.append(value);
                }
            } else {
                rawStrBuilder.append(value);
            }
            ++i;
        }
        String secret = HttpConfig.md5(Const.APP_KEY + paramDictionary.get("timestamp")).toLowerCase();
        return HttpConfig.md5(rawStrBuilder.toString() + secret).toLowerCase();
    }

    private String bodyToString(RequestBody request) {
        try {
            Buffer buffer = new Buffer();
            if (request == null) {
                return "";
            }
            request.writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "";
        }
    }
}

