/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import net.aihelp.core.net.mqtt.callback.ConnectCallback;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.callback.ReceiveListener;
import net.aihelp.core.net.mqtt.callback.SubscribeCallback;
import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.data.track.event.EventTracker;

public class AIHelpMqtt {
    private int connectionId;
    private int connectionType;
    private CallbackConnection mqttConnection;
    private CallbackConnection faqMqttConnection;
    private static ConnectingHandler mConnectingMonitor;

    public int getMqttConnectionId() {
        return this.connectionId;
    }

    public void prepare(IMqttCallback callback, int connectionType) {
        this.connectionType = connectionType;
        this.prepare(4, callback);
    }

    public void prepare(int type, IMqttCallback callback) {
        boolean isFaqRequest = type == 3;
        ++this.connectionId;
        this.mqttConnection = MqttConfig.getInstance().getMqttConnection(isFaqRequest, this.connectionId);
        this.mqttConnection.connect(new ConnectCallback(isFaqRequest, callback, this.connectionId));
        this.mqttConnection.listener(new ReceiveListener(isFaqRequest, callback, this.connectionId));
        this.mqttConnection.subscribe(MqttConfig.getInstance().getTopic(isFaqRequest), new SubscribeCallback(isFaqRequest, callback, this.connectionId, this.connectionType));
        if (isFaqRequest) {
            this.onFaqDestroy();
            this.faqMqttConnection = this.mqttConnection;
        }
        EventTracker.INSTANCE.log(304, MqttConfig.getInstance().getMqConfig());
    }

    public void onFaqDestroy() {
        if (this.faqMqttConnection != null) {
            this.faqMqttConnection.unregisterListener();
            this.faqMqttConnection.disconnect(null);
            this.faqMqttConnection = null;
        }
    }

    public void disconnect() {
        if (this.mqttConnection != null && this.mqttConnection.getIdentifier() == this.connectionId) {
            this.mqttConnection.unregisterListener();
            this.mqttConnection.disconnect(null);
            this.mqttConnection = null;
        }
    }

    public boolean isConnected() {
        return this.mqttConnection != null && this.mqttConnection.getIdentifier() == this.connectionId && this.mqttConnection.transport() != null && this.mqttConnection.transport().isConnected();
    }

    public CallbackConnection getMqttConnection() {
        return this.mqttConnection;
    }

    public static AIHelpMqtt getInstance() {
        return Holder.INSTANCE;
    }

    private AIHelpMqtt() {
        mConnectingMonitor = new ConnectingHandler();
    }

    public static class ConnectingHandler
    extends Handler {
        public void handleMessage(@NonNull Message msg) {
        }
    }

    private static class Holder {
        private static final AIHelpMqtt INSTANCE = new AIHelpMqtt();

        private Holder() {
        }
    }
}

