/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.Buffer;

public class MQTTFrame
extends MessageSupport.HeaderBase {
    private static final Buffer[] NO_BUFFERS = new Buffer[0];
    public Buffer[] buffers = NO_BUFFERS;

    public MQTTFrame() {
    }

    public MQTTFrame(Buffer buffer) {
        this(new Buffer[]{buffer});
    }

    public MQTTFrame(Buffer[] buffers) {
        this.buffers = buffers;
    }

    public Buffer[] buffers() {
        return this.buffers;
    }

    public MQTTFrame buffers(Buffer ... buffers) {
        this.buffers = buffers;
        return this;
    }

    public MQTTFrame buffer(Buffer buffer) {
        this.buffers = new Buffer[]{buffer};
        return this;
    }

    @Override
    public byte header() {
        return super.header();
    }

    @Override
    public MQTTFrame header(byte header) {
        return (MQTTFrame)super.header(header);
    }

    @Override
    public byte messageType() {
        return super.messageType();
    }

    @Override
    public MQTTFrame commandType(int type) {
        return (MQTTFrame)super.commandType(type);
    }

    @Override
    public boolean dup() {
        return super.dup();
    }

    @Override
    public MQTTFrame dup(boolean dup) {
        return (MQTTFrame)super.dup(dup);
    }

    @Override
    public QoS qos() {
        return super.qos();
    }

    @Override
    public MQTTFrame qos(QoS qos) {
        return (MQTTFrame)super.qos(qos);
    }

    @Override
    public boolean retain() {
        return super.retain();
    }

    @Override
    public MQTTFrame retain(boolean retain) {
        return (MQTTFrame)super.retain(retain);
    }

    public String toString() {
        String type = "unknown";
        switch (this.messageType()) {
            case 1: {
                type = "CONNECT";
                break;
            }
            case 2: {
                type = "CONNACK";
                break;
            }
            case 14: {
                type = "DISCONNECT";
                break;
            }
            case 12: {
                type = "PINGREQ";
                break;
            }
            case 13: {
                type = "PINGRESP";
                break;
            }
            case 8: {
                type = "SUBSCRIBE";
                break;
            }
            case 10: {
                type = "UNSUBSCRIBE";
                break;
            }
            case 11: {
                type = "UNSUBACK";
                break;
            }
            case 3: {
                type = "PUBLISH";
                break;
            }
            case 9: {
                type = "SUBACK";
                break;
            }
            case 4: {
                type = "PUBACK";
                break;
            }
            case 5: {
                type = "PUBREC";
                break;
            }
            case 6: {
                type = "PUBREL";
                break;
            }
            case 7: {
                type = "PUBCOMP";
                break;
            }
        }
        return "MQTTFrame { type: " + type + ", qos: " + (Object)((Object)this.qos()) + ", dup:" + this.dup() + " }";
    }
}

