/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.codec.MQTTFrame;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.Buffer;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;

public class PUBLISH
extends MessageSupport.HeaderBase
implements MessageSupport.Message,
MessageSupport.Acked {
    public static final byte TYPE = 3;
    private UTF8Buffer topicName;
    private short messageId;
    private Buffer payload;

    public PUBLISH() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    @Override
    public byte messageType() {
        return 3;
    }

    @Override
    public PUBLISH decode(MQTTFrame frame) throws ProtocolException {
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.topicName = MessageSupport.readUTF(is);
        QoS qos = this.qos();
        if (qos != QoS.AT_MOST_ONCE) {
            this.messageId = is.readShort();
        }
        this.payload = is.readBuffer(is.available());
        if (this.payload == null) {
            this.payload = new Buffer(0);
        }
        return this;
    }

    @Override
    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream();
            MessageSupport.writeUTF(os, this.topicName);
            QoS qos = this.qos();
            if (qos != QoS.AT_MOST_ONCE) {
                os.writeShort(this.messageId);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(3);
            if (this.payload != null && this.payload.length != 0) {
                os.write(this.payload);
            }
            frame.buffer(os.toBuffer());
            return frame;
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    @Override
    public boolean dup() {
        return super.dup();
    }

    @Override
    public PUBLISH dup(boolean dup) {
        return (PUBLISH)super.dup(dup);
    }

    @Override
    public QoS qos() {
        return super.qos();
    }

    @Override
    public PUBLISH qos(QoS qos) {
        return (PUBLISH)super.qos(qos);
    }

    @Override
    public boolean retain() {
        return super.retain();
    }

    @Override
    public PUBLISH retain(boolean retain) {
        return (PUBLISH)super.retain(retain);
    }

    @Override
    public short messageId() {
        return this.messageId;
    }

    @Override
    public PUBLISH messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public Buffer payload() {
        return this.payload;
    }

    public PUBLISH payload(Buffer payload) {
        this.payload = payload;
        return this;
    }

    public UTF8Buffer topicName() {
        return this.topicName;
    }

    public PUBLISH topicName(UTF8Buffer topicName) {
        this.topicName = topicName;
        return this;
    }

    public String toString() {
        return "PUBLISH{dup=" + this.dup() + ", qos=" + (Object)((Object)this.qos()) + ", retain=" + this.retain() + ", messageId=" + this.messageId + ", topicName=" + this.topicName + ", payload=" + this.payload + '}';
    }
}

