/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.codec.MQTTFrame;
import net.aihelp.core.net.mqtt.codec.MessageSupport;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayInputStream;
import net.aihelp.core.net.mqtt.hawtbuf.DataByteArrayOutputStream;
import net.aihelp.core.net.mqtt.hawtbuf.UTF8Buffer;

public class UNSUBSCRIBE
extends MessageSupport.HeaderBase
implements MessageSupport.Message,
MessageSupport.Acked {
    public static final byte TYPE = 10;
    public static final UTF8Buffer[] NO_TOPICS = new UTF8Buffer[0];
    private short messageId;
    private UTF8Buffer[] topics = NO_TOPICS;

    public UNSUBSCRIBE() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    @Override
    public byte messageType() {
        return 10;
    }

    @Override
    public UNSUBSCRIBE decode(MQTTFrame frame) throws ProtocolException {
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.messageId = is.readShort();
        ArrayList<UTF8Buffer> list = new ArrayList<UTF8Buffer>();
        while (is.available() > 0) {
            list.add(MessageSupport.readUTF(is));
        }
        this.topics = list.toArray(new UTF8Buffer[list.size()]);
        return this;
    }

    @Override
    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream();
            QoS qos = this.qos();
            if (qos != QoS.AT_MOST_ONCE) {
                os.writeShort(this.messageId);
            }
            for (UTF8Buffer topic : this.topics) {
                MessageSupport.writeUTF(os, topic);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(10);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    @Override
    public boolean dup() {
        return super.dup();
    }

    @Override
    public UNSUBSCRIBE dup(boolean dup) {
        return (UNSUBSCRIBE)super.dup(dup);
    }

    @Override
    public QoS qos() {
        return super.qos();
    }

    @Override
    public short messageId() {
        return this.messageId;
    }

    @Override
    public UNSUBSCRIBE messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public UTF8Buffer[] topics() {
        return this.topics;
    }

    public UNSUBSCRIBE topics(UTF8Buffer[] topics) {
        this.topics = topics;
        return this;
    }

    public String toString() {
        return "UNSUBSCRIBE{dup=" + this.dup() + ", qos=" + (Object)((Object)this.qos()) + ", messageId=" + this.messageId + ", topics=" + (this.topics == null ? null : Arrays.asList(this.topics)) + '}';
    }
}

