/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.config;

import android.text.TextUtils;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.client.CallbackConnection;
import net.aihelp.core.net.mqtt.client.MQTT;
import net.aihelp.core.net.mqtt.client.QoS;
import net.aihelp.core.net.mqtt.client.Topic;
import net.aihelp.utils.TLog;

public class MqttConfig {
    public static final int TYPE_ELVA_BOT = 1;
    public static final int TYPE_CONVERSATION = 2;
    public static final int TYPE_FAQ = 3;
    public static final int TYPE_RPA = 4;
    public static final int TYPE_CONNECTION_LOGIN = 1;
    public static final int TYPE_CONNECTION_RECONNECT = 2;
    private int loginType;
    private StringBuilder mqConfig = new StringBuilder();

    public int getLoginType() {
        return this.loginType;
    }

    public void setLoginType(int type) {
        this.loginType = type;
    }

    public boolean isConnected() {
        return AIHelpMqtt.getInstance().isConnected();
    }

    public CallbackConnection getMqttConnection(boolean isFaq, int connectionIdentifier) {
        MQTT mqtt = new MQTT();
        try {
            int port;
            String ip;
            this.mqConfig = new StringBuilder();
            String string = ip = isFaq ? API.MQTT_FAQ_IP : API.MQTT_IP;
            int n = isFaq ? Integer.parseInt(TextUtils.isEmpty((CharSequence)API.MQTT_FAQ_PORT) ? "1883" : API.MQTT_FAQ_PORT) : (port = Integer.parseInt(TextUtils.isEmpty((CharSequence)API.MQTT_PORT) ? "1883" : API.MQTT_PORT));
            if (Const.TOGGLE_MQTT_TLS) {
                mqtt.setHost(new URI(String.format("tls://%s:%s", ip, port)));
            } else {
                mqtt.setHost(ip, port);
            }
            this.mqConfig.append(String.format("%s:%s, ", ip, port));
            mqtt.setWillQos(QoS.AT_MOST_ONCE);
            mqtt.setUserName(Const.APP_ID);
            mqtt.setPassword(this.md5(Const.APP_ID));
            this.mqConfig.append(String.format("userName:%s, pwd: %s, ", Const.APP_ID, this.md5(Const.APP_ID)));
            String clientId = "android_" + UUID.randomUUID();
            if (isFaq) {
                clientId = clientId + "_faq";
            }
            mqtt.setClientId(clientId);
            this.mqConfig.append(String.format("clientId:%s", clientId));
            mqtt.setConnectAttemptsMax(5L);
            mqtt.setReconnectAttemptsMax(5L);
            TLog.d("mqConfig: " + this.mqConfig.toString());
        }
        catch (Exception ip) {
            // empty catch block
        }
        CallbackConnection callbackConnection = mqtt.callbackConnection();
        callbackConnection.setIdentifier(connectionIdentifier);
        return callbackConnection;
    }

    public Topic[] getTopic(boolean isFaq) {
        Topic[] topicArray;
        String topicName = String.format("elva/%s/%s/%s/%s", API.MQTT_TOPIC, Const.APP_ID, UserProfile.USER_ID, "pushSdkMessage");
        if (isFaq) {
            Topic[] topicArray2 = new Topic[1];
            topicArray = topicArray2;
            topicArray2[0] = new Topic(topicName, QoS.AT_MOST_ONCE);
        } else {
            topicArray = this.getNormalTopics();
        }
        return topicArray;
    }

    private Topic[] getNormalTopics() {
        String[] topics = new String[]{"pushChat", "pushFormChat", "pushWithdraw", "ticketRejected", "pushNotification"};
        Topic[] t = new Topic[topics.length];
        for (int i = 0; i < topics.length; ++i) {
            String topicName = String.format("elva/%s/%s/%s/%s", API.MQTT_TOPIC, Const.APP_ID, UserProfile.USER_ID, topics[i]);
            t[i] = new Topic(topicName, QoS.AT_MOST_ONCE);
        }
        return t;
    }

    public static String newTopic(String topic) {
        return String.format("%s/%s/%s/%s", API.MQTT_TOPIC, Const.APP_ID, UserProfile.USER_ID, topic);
    }

    private String md5(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            byte[] hash = new byte[]{};
            try {
                hash = MessageDigest.getInstance("MD5").digest(string.getBytes(Charset.forName("UTF-8")));
            }
            catch (NoSuchAlgorithmException e) {
                TLog.d("RuntimeException Huh, MD5 should be supported? " + e.toString());
                return string;
            }
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append("0");
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        return "";
    }

    public String getMqConfig() {
        return this.mqConfig.toString();
    }

    private MqttConfig() {
    }

    public static MqttConfig getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final MqttConfig INSTANCE = new MqttConfig();

        private Holder() {
        }
    }
}

