/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtdispatch.internal;

import java.util.concurrent.atomic.AtomicLong;
import net.aihelp.core.net.mqtt.hawtdispatch.DispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Metrics;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.MetricsCollector;

public final class ActiveMetricsCollector
extends MetricsCollector {
    private final DispatchQueue queue;
    private final AtomicLong max_run_time = new AtomicLong();
    private final AtomicLong max_wait_time = new AtomicLong();
    private final AtomicLong enqueued = new AtomicLong();
    private final AtomicLong dequeued = new AtomicLong();
    private final AtomicLong total_run_time = new AtomicLong();
    private final AtomicLong total_wait_time = new AtomicLong();
    private final AtomicLong reset_at = new AtomicLong(System.nanoTime());

    public ActiveMetricsCollector(DispatchQueue queue) {
        this.queue = queue;
    }

    private void setMax(AtomicLong holder, long value) {
        long p;
        while (value > (p = holder.get())) {
            if (!holder.compareAndSet(p, value)) continue;
            return;
        }
    }

    @Override
    public Task track(final Task runnable) {
        this.enqueued.incrementAndGet();
        final long enqueuedAt = System.nanoTime();
        return new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long dequeued_at = System.nanoTime();
                long wait_time = dequeued_at - enqueuedAt;
                ActiveMetricsCollector.this.total_wait_time.addAndGet(wait_time);
                ActiveMetricsCollector.this.setMax(ActiveMetricsCollector.this.max_wait_time, wait_time);
                ActiveMetricsCollector.this.dequeued.incrementAndGet();
                long dequeuedAt = dequeued_at;
                try {
                    runnable.run();
                }
                finally {
                    long run_time = System.nanoTime() - dequeuedAt;
                    ActiveMetricsCollector.this.total_run_time.addAndGet(run_time);
                    ActiveMetricsCollector.this.setMax(ActiveMetricsCollector.this.max_run_time, run_time);
                }
            }
        };
    }

    @Override
    public Metrics metrics() {
        long now = System.nanoTime();
        long start = this.reset_at.getAndSet(now);
        long enq = this.enqueued.getAndSet(0L);
        long deq = this.dequeued.getAndSet(0L);
        if (enq == 0L && deq == 0L) {
            return null;
        }
        Metrics rc = new Metrics();
        rc.durationNS = now - start;
        rc.queue = this.queue;
        rc.enqueued = enq;
        rc.dequeued = deq;
        rc.maxWaitTimeNS = this.max_wait_time.getAndSet(0L);
        rc.maxRunTimeNS = this.max_run_time.getAndSet(0L);
        rc.totalRunTimeNS = this.total_run_time.getAndSet(0L);
        rc.totalWaitTimeNS = this.total_wait_time.getAndSet(0L);
        return rc;
    }
}

