/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtdispatch.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.aihelp.core.net.mqtt.hawtdispatch.Suspendable;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;

public class BaseSuspendable
extends Task
implements Suspendable {
    protected final AtomicBoolean startup = new AtomicBoolean(true);
    protected final AtomicInteger suspended = new AtomicInteger();

    @Override
    public boolean isSuspended() {
        return this.suspended.get() > 0;
    }

    @Override
    public void resume() {
        if (this.suspended.decrementAndGet() == 0) {
            if (this.startup.compareAndSet(true, false)) {
                this.onStartup();
            } else {
                this.onResume();
            }
        }
    }

    @Override
    public void suspend() {
        if (this.suspended.getAndIncrement() == 0) {
            this.onSuspend();
        }
    }

    protected void onStartup() {
    }

    protected void onSuspend() {
    }

    protected void onResume() {
    }

    @Override
    public void run() {
    }
}

