/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.hawtdispatch.internal.pool;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.Task;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.NioManager;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.ThreadDispatchQueue;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.WorkerThread;
import net.aihelp.core.net.mqtt.hawtdispatch.internal.pool.SimplePool;

public class SimpleThread
extends WorkerThread {
    private SimplePool pool;
    private ThreadDispatchQueue threadQueue;
    private final NioManager nioManager;
    public static final boolean DEBUG = false;

    public SimpleThread(SimplePool pool) throws IOException {
        super(pool.group, pool.name);
        this.pool = pool;
        this.nioManager = new NioManager();
        this.threadQueue = new ThreadDispatchQueue(pool.globalQueue, this);
    }

    @Override
    public ThreadDispatchQueue getDispatchQueue() {
        return this.threadQueue;
    }

    @Override
    public void unpark() {
        this.nioManager.wakeupIfSelecting();
    }

    @Override
    public NioManager getNioManager() {
        return this.nioManager;
    }

    @Override
    public void run() {
        this.debug("run start", new Object[0]);
        try {
            ConcurrentLinkedQueue<Task> sharedQueue = this.pool.tasks;
            while (!this.pool.shutdown) {
                Task task = this.threadQueue.poll();
                if (task == null && (task = sharedQueue.poll()) == null) {
                    task = this.threadQueue.getSourceQueue().poll();
                }
                if (task == null) {
                    this.pool.park(this);
                    continue;
                }
                task.run();
            }
        }
        finally {
            this.debug("run end", new Object[0]);
        }
    }

    protected void debug(String str, Object ... args) {
    }

    protected void debug(Throwable thrown, String str, Object ... args) {
    }
}

