/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.tansport;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.aihelp.core.net.mqtt.tansport.PipeTransportServer;
import net.aihelp.core.net.mqtt.tansport.Transport;
import net.aihelp.core.net.mqtt.tansport.TransportServer;

public class PipeTransportRegistry {
    public static final HashMap<String, PipeTransportServer> servers = new HashMap();

    public static synchronized TransportServer bind(String location) throws URISyntaxException, IOException {
        if (servers.containsKey(location)) {
            throw new IOException("Server already bound: " + location);
        }
        PipeTransportServer server = new PipeTransportServer();
        server.setConnectURI(location);
        server.setName(location);
        servers.put(location, server);
        return server;
    }

    public static synchronized Transport connect(String location) throws IOException, URISyntaxException {
        PipeTransportServer server = PipeTransportRegistry.lookup(location);
        if (server == null) {
            throw new IOException("Server is not bound: " + location);
        }
        return server.connect();
    }

    public static synchronized PipeTransportServer lookup(String name) {
        return servers.get(name);
    }

    public static synchronized Map<String, PipeTransportServer> getServers() {
        return new HashMap<String, PipeTransportServer>(servers);
    }

    public static synchronized void unbind(PipeTransportServer server) {
        servers.remove(server.getName());
    }
}

