/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.net.mqtt.util;

import java.util.ArrayList;

public abstract class ThreadLocalPool<T> {
    private final ThreadLocal<Pool> objectsThreadLocal = new ThreadLocal();

    protected abstract T create();

    protected int maxPoolSizePerThread() {
        return 10;
    }

    private Pool getPool() {
        Pool rc = this.objectsThreadLocal.get();
        if (rc == null) {
            rc = new Pool();
            this.objectsThreadLocal.set(rc);
        }
        return rc;
    }

    public T checkout() {
        Pool pool = this.getPool();
        ArrayList objects = pool.objects;
        if (!objects.isEmpty()) {
            ++pool.hitCounter;
            return objects.remove(objects.size() - 1);
        }
        ++pool.missCounter;
        return this.create();
    }

    public void checkin(T value) {
        ArrayList objects = this.getPool().objects;
        if (objects.size() < this.maxPoolSizePerThread()) {
            objects.add(value);
        }
    }

    class Pool {
        final ArrayList<T> objects;
        long hitCounter;
        long missCounter;

        Pool() {
            this.objects = new ArrayList(ThreadLocalPool.this.maxPoolSizePerThread());
        }
    }
}

