/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.adapter;

import android.util.Log;
import androidx.collection.SparseArrayCompat;
import java.util.List;
import net.aihelp.core.ui.adapter.ItemViewDelegate;
import net.aihelp.core.ui.adapter.ViewHolder;

public class ItemViewDelegateManager<T> {
    private SparseArrayCompat<ItemViewDelegate<T>> delegates = new SparseArrayCompat();

    int getItemViewDelegateCount() {
        return this.delegates.size();
    }

    void addDelegate(ItemViewDelegate<T> delegate) {
        int viewType = this.delegates.size();
        if (delegate != null) {
            this.delegates.put(viewType, delegate);
            ++viewType;
        }
    }

    void addDelegate(int viewType, ItemViewDelegate<T> delegate) {
        if (this.delegates.get(viewType) != null) {
            Log.e((String)"AIHelp", (String)("An ItemViewDelegate is already registered for the viewType = " + viewType + ". Already registered ItemViewDelegate is " + this.delegates.get(viewType)));
            return;
        }
        this.delegates.put(viewType, delegate);
    }

    public ItemViewDelegateManager<T> removeDelegate(ItemViewDelegate<T> delegate) {
        int indexToRemove;
        if (delegate != null && (indexToRemove = this.delegates.indexOfValue(delegate)) >= 0) {
            this.delegates.removeAt(indexToRemove);
        }
        return this;
    }

    void removeDelegate(int itemType) {
        int indexToRemove = this.delegates.indexOfKey(itemType);
        if (indexToRemove >= 0) {
            this.delegates.removeAt(indexToRemove);
        }
    }

    int getItemViewType(T item, int position) {
        int delegatesCount = this.delegates.size();
        for (int i = delegatesCount - 1; i >= 0; --i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(item, position)) continue;
            return this.delegates.keyAt(i);
        }
        return -1;
    }

    public void convert(ViewHolder holder, T item, int position) {
        int delegatesCount = this.delegates.size();
        for (int i = 0; i < delegatesCount; ++i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            if (!delegate.isForViewType(item, position)) continue;
            delegate.convert(holder, item, position);
            return;
        }
    }

    public void notifyDataSetChanged(List<T> data) {
        int delegatesCount = this.delegates.size();
        for (int i = 0; i < delegatesCount; ++i) {
            ItemViewDelegate delegate = (ItemViewDelegate)this.delegates.valueAt(i);
            delegate.onDataSourceUpdated(data);
        }
    }

    ItemViewDelegate getItemViewDelegate(int viewType) {
        return (ItemViewDelegate)this.delegates.get(viewType);
    }

    public int getItemViewLayoutId(int viewType) {
        return this.getItemViewDelegate(viewType).getItemViewLayoutId();
    }

    public int getItemViewType(ItemViewDelegate itemViewDelegate) {
        return this.delegates.indexOfValue((Object)itemViewDelegate);
    }
}

