/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.dialog;

import android.content.Context;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import java.lang.ref.WeakReference;

class DialogViewHelper {
    private View mContentView = null;
    private SparseArray<WeakReference<View>> mViews = new SparseArray();

    public DialogViewHelper(Context context, int layoutResId) {
        this();
        this.mContentView = LayoutInflater.from((Context)context).inflate(layoutResId, null);
    }

    public DialogViewHelper() {
    }

    public void setContentView(View view) {
        this.mContentView = view;
    }

    public void setText(int viewId, CharSequence text) {
        TextView view = (TextView)this.getView(viewId);
        if (view != null) {
            view.setText(text);
        }
    }

    public void setBottomText(int viewId, CharSequence text) {
        TextView view = (TextView)this.getView(viewId);
        if (view != null) {
            view.setText(text);
        }
    }

    public void setOnClickListener(int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        if (view != null) {
            view.setOnClickListener(listener);
        }
    }

    public void setBackground(int viewId, int resId) {
        Object view = this.getView(viewId);
        if (view != null) {
            view.setBackgroundResource(resId);
        }
    }

    public View getContentView() {
        return this.mContentView;
    }

    public <V extends View> V getView(int viewId) {
        View view = null;
        WeakReference viewWeakReference = (WeakReference)this.mViews.get(viewId);
        if (viewWeakReference != null) {
            view = (View)viewWeakReference.get();
        }
        if (view == null) {
            view = this.mContentView.findViewById(viewId);
            this.mViews.put(viewId, new WeakReference<View>(view));
        }
        return (V)view;
    }
}

