/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide;

import android.content.Context;
import java.io.File;
import net.aihelp.core.ui.glide.DownloadOptions;
import net.aihelp.core.ui.glide.GenericRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.Priority;
import net.aihelp.core.ui.glide.RequestManager;
import net.aihelp.core.ui.glide.load.engine.DiskCacheStrategy;
import net.aihelp.core.ui.glide.load.model.ModelLoader;
import net.aihelp.core.ui.glide.load.resource.transcode.ResourceTranscoder;
import net.aihelp.core.ui.glide.load.resource.transcode.UnitTranscoder;
import net.aihelp.core.ui.glide.manager.Lifecycle;
import net.aihelp.core.ui.glide.manager.RequestTracker;
import net.aihelp.core.ui.glide.provider.DataLoadProvider;
import net.aihelp.core.ui.glide.provider.FixedLoadProvider;
import net.aihelp.core.ui.glide.provider.LoadProvider;
import net.aihelp.core.ui.glide.request.FutureTarget;
import net.aihelp.core.ui.glide.request.target.Target;

public class GenericTranscodeRequest<ModelType, DataType, ResourceType>
extends GenericRequestBuilder<ModelType, DataType, ResourceType, ResourceType>
implements DownloadOptions {
    private final ModelLoader<ModelType, DataType> modelLoader;
    private final Class<DataType> dataClass;
    private final Class<ResourceType> resourceClass;
    private final RequestManager.OptionsApplier optionsApplier;

    private static <A, T, Z, R> LoadProvider<A, T, Z, R> build(Glide glide, ModelLoader<A, T> modelLoader, Class<T> dataClass, Class<Z> resourceClass, ResourceTranscoder<Z, R> transcoder) {
        DataLoadProvider<T, Z> dataLoadProvider = glide.buildDataProvider(dataClass, resourceClass);
        return new FixedLoadProvider<A, T, Z, R>(modelLoader, transcoder, dataLoadProvider);
    }

    GenericTranscodeRequest(Class<ResourceType> transcodeClass, GenericRequestBuilder<ModelType, ?, ?, ?> other, ModelLoader<ModelType, DataType> modelLoader, Class<DataType> dataClass, Class<ResourceType> resourceClass, RequestManager.OptionsApplier optionsApplier) {
        super(GenericTranscodeRequest.build(other.glide, modelLoader, dataClass, resourceClass, UnitTranscoder.get()), transcodeClass, other);
        this.modelLoader = modelLoader;
        this.dataClass = dataClass;
        this.resourceClass = resourceClass;
        this.optionsApplier = optionsApplier;
    }

    GenericTranscodeRequest(Context context, Glide glide, Class<ModelType> modelClass, ModelLoader<ModelType, DataType> modelLoader, Class<DataType> dataClass, Class<ResourceType> resourceClass, RequestTracker requestTracker, Lifecycle lifecycle, RequestManager.OptionsApplier optionsApplier) {
        super(context, modelClass, GenericTranscodeRequest.build(glide, modelLoader, dataClass, resourceClass, UnitTranscoder.get()), resourceClass, glide, requestTracker, lifecycle);
        this.modelLoader = modelLoader;
        this.dataClass = dataClass;
        this.resourceClass = resourceClass;
        this.optionsApplier = optionsApplier;
    }

    public <TranscodeType> GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType> transcode(ResourceTranscoder<ResourceType, TranscodeType> transcoder, Class<TranscodeType> transcodeClass) {
        LoadProvider<ModelType, DataType, ResourceType, TranscodeType> loadProvider = GenericTranscodeRequest.build(this.glide, this.modelLoader, this.dataClass, this.resourceClass, transcoder);
        return this.optionsApplier.apply(new GenericRequestBuilder<ModelType, DataType, ResourceType, TranscodeType>(loadProvider, transcodeClass, this));
    }

    @Override
    public <Y extends Target<File>> Y downloadOnly(Y target) {
        return this.getDownloadOnlyRequest().into(target);
    }

    @Override
    public FutureTarget<File> downloadOnly(int width, int height) {
        return this.getDownloadOnlyRequest().into(width, height);
    }

    private GenericRequestBuilder<ModelType, DataType, File, File> getDownloadOnlyRequest() {
        ResourceTranscoder transcoder = UnitTranscoder.get();
        DataLoadProvider<DataType, File> dataLoadProvider = this.glide.buildDataProvider(this.dataClass, File.class);
        FixedLoadProvider fixedLoadProvider = new FixedLoadProvider(this.modelLoader, transcoder, dataLoadProvider);
        return this.optionsApplier.apply(new GenericRequestBuilder<ModelType, DataType, File, File>(fixedLoadProvider, File.class, this)).priority(Priority.LOW).diskCacheStrategy(DiskCacheStrategy.SOURCE).skipMemoryCache(true);
    }
}

