/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide;

import android.content.Context;
import android.os.Build;
import java.util.concurrent.ExecutorService;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.DecodeFormat;
import net.aihelp.core.ui.glide.load.engine.Engine;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.LruBitmapPool;
import net.aihelp.core.ui.glide.load.engine.cache.DiskCache;
import net.aihelp.core.ui.glide.load.engine.cache.InternalCacheDiskCacheFactory;
import net.aihelp.core.ui.glide.load.engine.cache.LruResourceCache;
import net.aihelp.core.ui.glide.load.engine.cache.MemoryCache;
import net.aihelp.core.ui.glide.load.engine.cache.MemorySizeCalculator;
import net.aihelp.core.ui.glide.load.engine.executor.FifoPriorityThreadPoolExecutor;

public class GlideBuilder {
    private final Context context;
    private Engine engine;
    private BitmapPool bitmapPool;
    private MemoryCache memoryCache;
    private ExecutorService sourceService;
    private ExecutorService diskCacheService;
    private DecodeFormat decodeFormat;
    private DiskCache.Factory diskCacheFactory;

    public GlideBuilder(Context context) {
        this.context = context.getApplicationContext();
    }

    public GlideBuilder setBitmapPool(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
        return this;
    }

    public GlideBuilder setMemoryCache(MemoryCache memoryCache) {
        this.memoryCache = memoryCache;
        return this;
    }

    @Deprecated
    public GlideBuilder setDiskCache(final DiskCache diskCache) {
        return this.setDiskCache(new DiskCache.Factory(){

            @Override
            public DiskCache build() {
                return diskCache;
            }
        });
    }

    public GlideBuilder setDiskCache(DiskCache.Factory diskCacheFactory) {
        this.diskCacheFactory = diskCacheFactory;
        return this;
    }

    public GlideBuilder setResizeService(ExecutorService service) {
        this.sourceService = service;
        return this;
    }

    public GlideBuilder setDiskCacheService(ExecutorService service) {
        this.diskCacheService = service;
        return this;
    }

    public GlideBuilder setDecodeFormat(DecodeFormat decodeFormat) {
        this.decodeFormat = decodeFormat;
        return this;
    }

    GlideBuilder setEngine(Engine engine) {
        this.engine = engine;
        return this;
    }

    Glide createGlide() {
        if (this.sourceService == null) {
            int cores = Math.max(1, Runtime.getRuntime().availableProcessors());
            this.sourceService = new FifoPriorityThreadPoolExecutor(cores);
        }
        if (this.diskCacheService == null) {
            this.diskCacheService = new FifoPriorityThreadPoolExecutor(1);
        }
        MemorySizeCalculator calculator = new MemorySizeCalculator(this.context);
        if (this.bitmapPool == null) {
            if (Build.VERSION.SDK_INT >= 11) {
                int size = calculator.getBitmapPoolSize();
                this.bitmapPool = new LruBitmapPool(size);
            } else {
                this.bitmapPool = new BitmapPoolAdapter();
            }
        }
        if (this.memoryCache == null) {
            this.memoryCache = new LruResourceCache(calculator.getMemoryCacheSize());
        }
        if (this.diskCacheFactory == null) {
            this.diskCacheFactory = new InternalCacheDiskCacheFactory(this.context);
        }
        if (this.engine == null) {
            this.engine = new Engine(this.memoryCache, this.diskCacheFactory, this.diskCacheService, this.sourceService);
        }
        if (this.decodeFormat == null) {
            this.decodeFormat = DecodeFormat.DEFAULT;
        }
        return new Glide(this.engine, this.memoryCache, this.bitmapPool, this.context, this.decodeFormat);
    }
}

