/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide;

import android.widget.AbsListView;
import java.util.List;
import java.util.Queue;
import net.aihelp.core.ui.glide.GenericRequestBuilder;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.request.animation.GlideAnimation;
import net.aihelp.core.ui.glide.request.target.BaseTarget;
import net.aihelp.core.ui.glide.request.target.SizeReadyCallback;
import net.aihelp.core.ui.glide.util.Util;

public class ListPreloader<T>
implements AbsListView.OnScrollListener {
    private final int maxPreload;
    private final PreloadTargetQueue preloadTargetQueue;
    private final PreloadModelProvider<T> preloadModelProvider;
    private final PreloadSizeProvider<T> preloadDimensionProvider;
    private int lastEnd;
    private int lastStart;
    private int lastFirstVisible;
    private int totalItemCount;
    private boolean isIncreasing = true;

    @Deprecated
    public ListPreloader(int maxPreload) {
        this.preloadModelProvider = new PreloadModelProvider<T>(){

            @Override
            public List<T> getPreloadItems(int position) {
                return ListPreloader.this.getItems(position, position + 1);
            }

            @Override
            public GenericRequestBuilder getPreloadRequestBuilder(T item) {
                return ListPreloader.this.getRequestBuilder(item);
            }
        };
        this.preloadDimensionProvider = new PreloadSizeProvider<T>(){

            @Override
            public int[] getPreloadSize(T item, int adapterPosition, int perItemPosition) {
                return ListPreloader.this.getDimensions(item);
            }
        };
        this.maxPreload = maxPreload;
        this.preloadTargetQueue = new PreloadTargetQueue(maxPreload + 1);
    }

    public ListPreloader(PreloadModelProvider<T> preloadModelProvider, PreloadSizeProvider<T> preloadDimensionProvider, int maxPreload) {
        this.preloadModelProvider = preloadModelProvider;
        this.preloadDimensionProvider = preloadDimensionProvider;
        this.maxPreload = maxPreload;
        this.preloadTargetQueue = new PreloadTargetQueue(maxPreload + 1);
    }

    public void onScrollStateChanged(AbsListView absListView, int scrollState) {
    }

    public void onScroll(AbsListView absListView, int firstVisible, int visibleCount, int totalCount) {
        this.totalItemCount = totalCount;
        if (firstVisible > this.lastFirstVisible) {
            this.preload(firstVisible + visibleCount, true);
        } else if (firstVisible < this.lastFirstVisible) {
            this.preload(firstVisible, false);
        }
        this.lastFirstVisible = firstVisible;
    }

    @Deprecated
    protected int[] getDimensions(T item) {
        throw new IllegalStateException("You must either provide a PreloadDimensionProvider or override getDimensions()");
    }

    @Deprecated
    protected List<T> getItems(int start, int end) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider or override getItems()");
    }

    @Deprecated
    protected GenericRequestBuilder getRequestBuilder(T item) {
        throw new IllegalStateException("You must either provide a PreloadModelProvider, or override getRequestBuilder()");
    }

    private void preload(int start, boolean increasing) {
        if (this.isIncreasing != increasing) {
            this.isIncreasing = increasing;
            this.cancelAll();
        }
        this.preload(start, start + (increasing ? this.maxPreload : -this.maxPreload));
    }

    private void preload(int from, int to) {
        int end;
        int start;
        if (from < to) {
            start = Math.max(this.lastEnd, from);
            end = to;
        } else {
            start = to;
            end = Math.min(this.lastStart, from);
        }
        end = Math.min(this.totalItemCount, end);
        start = Math.min(this.totalItemCount, Math.max(0, start));
        if (from < to) {
            for (int i = start; i < end; ++i) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i), i, true);
            }
        } else {
            for (int i = end - 1; i >= start; --i) {
                this.preloadAdapterPosition(this.preloadModelProvider.getPreloadItems(i), i, false);
            }
        }
        this.lastStart = start;
        this.lastEnd = end;
    }

    private void preloadAdapterPosition(List<T> items, int position, boolean isIncreasing) {
        int numItems = items.size();
        if (isIncreasing) {
            for (int i = 0; i < numItems; ++i) {
                this.preloadItem(items.get(i), position, i);
            }
        } else {
            for (int i = numItems - 1; i >= 0; --i) {
                this.preloadItem(items.get(i), position, i);
            }
        }
    }

    private void preloadItem(T item, int position, int i) {
        int[] dimensions = this.preloadDimensionProvider.getPreloadSize(item, position, i);
        if (dimensions != null) {
            GenericRequestBuilder preloadRequestBuilder = this.preloadModelProvider.getPreloadRequestBuilder(item);
            preloadRequestBuilder.into(this.preloadTargetQueue.next(dimensions[0], dimensions[1]));
        }
    }

    private void cancelAll() {
        for (int i = 0; i < this.maxPreload; ++i) {
            Glide.clear(this.preloadTargetQueue.next(0, 0));
        }
    }

    private static class PreloadTarget
    extends BaseTarget<Object> {
        private int photoHeight;
        private int photoWidth;

        private PreloadTarget() {
        }

        @Override
        public void onResourceReady(Object resource, GlideAnimation<? super Object> glideAnimation) {
        }

        @Override
        public void getSize(SizeReadyCallback cb) {
            cb.onSizeReady(this.photoWidth, this.photoHeight);
        }
    }

    private static final class PreloadTargetQueue {
        private final Queue<PreloadTarget> queue;

        public PreloadTargetQueue(int size) {
            this.queue = Util.createQueue(size);
            for (int i = 0; i < size; ++i) {
                this.queue.offer(new PreloadTarget());
            }
        }

        public PreloadTarget next(int width, int height) {
            PreloadTarget result = this.queue.poll();
            this.queue.offer(result);
            result.photoWidth = width;
            result.photoHeight = height;
            return result;
        }
    }

    public static interface PreloadSizeProvider<T> {
        public int[] getPreloadSize(T var1, int var2, int var3);
    }

    public static interface PreloadModelProvider<U> {
        public List<U> getPreloadItems(int var1);

        public GenericRequestBuilder getPreloadRequestBuilder(U var1);
    }
}

