/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.data;

import android.content.res.AssetManager;
import android.util.Log;
import java.io.IOException;
import net.aihelp.core.ui.glide.Priority;
import net.aihelp.core.ui.glide.load.data.DataFetcher;

public abstract class AssetPathFetcher<T>
implements DataFetcher<T> {
    private static final String TAG = "AssetUriFetcher";
    private final String assetPath;
    private final AssetManager assetManager;
    private T data;

    public AssetPathFetcher(AssetManager assetManager, String assetPath) {
        this.assetManager = assetManager;
        this.assetPath = assetPath;
    }

    @Override
    public T loadData(Priority priority) throws Exception {
        this.data = this.loadResource(this.assetManager, this.assetPath);
        return this.data;
    }

    @Override
    public void cleanup() {
        block3: {
            if (this.data == null) {
                return;
            }
            try {
                this.close(this.data);
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)2)) break block3;
                Log.v((String)TAG, (String)"Failed to close data", (Throwable)e);
            }
        }
    }

    @Override
    public String getId() {
        return this.assetPath;
    }

    @Override
    public void cancel() {
    }

    protected abstract T loadResource(AssetManager var1, String var2) throws IOException;

    protected abstract void close(T var1) throws IOException;
}

