/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.engine.cache;

import java.io.File;
import net.aihelp.core.ui.glide.load.engine.cache.DiskCache;
import net.aihelp.core.ui.glide.load.engine.cache.DiskLruCacheWrapper;

public class DiskLruCacheFactory
implements DiskCache.Factory {
    private final int diskCacheSize;
    private final CacheDirectoryGetter cacheDirectoryGetter;

    public DiskLruCacheFactory(final String diskCacheFolder, int diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(final String diskCacheFolder, final String diskCacheName, int diskCacheSize) {
        this(new CacheDirectoryGetter(){

            @Override
            public File getCacheDirectory() {
                return new File(diskCacheFolder, diskCacheName);
            }
        }, diskCacheSize);
    }

    public DiskLruCacheFactory(CacheDirectoryGetter cacheDirectoryGetter, int diskCacheSize) {
        this.diskCacheSize = diskCacheSize;
        this.cacheDirectoryGetter = cacheDirectoryGetter;
    }

    @Override
    public DiskCache build() {
        File cacheDir = this.cacheDirectoryGetter.getCacheDirectory();
        if (cacheDir == null) {
            return null;
        }
        if (!(cacheDir.mkdirs() || cacheDir.exists() && cacheDir.isDirectory())) {
            return null;
        }
        return DiskLruCacheWrapper.get(cacheDir, this.diskCacheSize);
    }

    public static interface CacheDirectoryGetter {
        public File getCacheDirectory();
    }
}

