/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.OutputStream;
import net.aihelp.core.ui.glide.load.ResourceEncoder;
import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.util.LogTime;
import net.aihelp.core.ui.glide.util.Util;

public class BitmapEncoder
implements ResourceEncoder<Bitmap> {
    private static final String TAG = "BitmapEncoder";
    private static final int DEFAULT_COMPRESSION_QUALITY = 90;
    private Bitmap.CompressFormat compressFormat;
    private int quality;

    public BitmapEncoder() {
        this(null, 90);
    }

    public BitmapEncoder(Bitmap.CompressFormat compressFormat, int quality) {
        this.compressFormat = compressFormat;
        this.quality = quality;
    }

    @Override
    public boolean encode(Resource<Bitmap> resource, OutputStream os) {
        Bitmap bitmap = resource.get();
        long start = LogTime.getLogTime();
        Bitmap.CompressFormat format = this.getFormat(bitmap);
        bitmap.compress(format, this.quality, os);
        if (Log.isLoggable((String)TAG, (int)2)) {
            Log.v((String)TAG, (String)("Compressed with type: " + format + " of size " + Util.getBitmapByteSize(bitmap) + " in " + LogTime.getElapsedMillis(start)));
        }
        return true;
    }

    @Override
    public String getId() {
        return "BitmapEncoder.net.aihelp.core.ui.glide.load.resource.bitmap";
    }

    private Bitmap.CompressFormat getFormat(Bitmap bitmap) {
        if (this.compressFormat != null) {
            return this.compressFormat;
        }
        if (bitmap.hasAlpha()) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }
}

