/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.bitmap;

import android.content.Context;
import android.graphics.Bitmap;
import net.aihelp.core.ui.glide.Glide;
import net.aihelp.core.ui.glide.load.Transformation;
import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.resource.bitmap.BitmapResource;
import net.aihelp.core.ui.glide.util.Util;

public abstract class BitmapTransformation
implements Transformation<Bitmap> {
    private BitmapPool bitmapPool;

    public BitmapTransformation(Context context) {
        this(Glide.get(context).getBitmapPool());
    }

    public BitmapTransformation(BitmapPool bitmapPool) {
        this.bitmapPool = bitmapPool;
    }

    @Override
    public final Resource<Bitmap> transform(Resource<Bitmap> resource, int outWidth, int outHeight) {
        if (!Util.isValidDimensions(outWidth, outHeight)) {
            throw new IllegalArgumentException("Cannot apply transformation on width: " + outWidth + " or height: " + outHeight + " less than or equal to zero and not Target.SIZE_ORIGINAL");
        }
        Bitmap toTransform = resource.get();
        int targetWidth = outWidth == Integer.MIN_VALUE ? toTransform.getWidth() : outWidth;
        int targetHeight = outHeight == Integer.MIN_VALUE ? toTransform.getHeight() : outHeight;
        Bitmap transformed = this.transform(this.bitmapPool, toTransform, targetWidth, targetHeight);
        BitmapResource result = toTransform.equals(transformed) ? resource : BitmapResource.obtain(transformed, this.bitmapPool);
        return result;
    }

    protected abstract Bitmap transform(BitmapPool var1, Bitmap var2, int var3, int var4);
}

