/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.load.resource.gifbitmap;

import android.graphics.Bitmap;
import net.aihelp.core.ui.glide.load.Transformation;
import net.aihelp.core.ui.glide.load.engine.Resource;
import net.aihelp.core.ui.glide.load.engine.bitmap_recycle.BitmapPool;
import net.aihelp.core.ui.glide.load.resource.gif.GifDrawable;
import net.aihelp.core.ui.glide.load.resource.gif.GifDrawableTransformation;
import net.aihelp.core.ui.glide.load.resource.gifbitmap.GifBitmapWrapper;
import net.aihelp.core.ui.glide.load.resource.gifbitmap.GifBitmapWrapperResource;

public class GifBitmapWrapperTransformation
implements Transformation<GifBitmapWrapper> {
    private final Transformation<Bitmap> bitmapTransformation;
    private final Transformation<GifDrawable> gifDataTransformation;

    public GifBitmapWrapperTransformation(BitmapPool bitmapPool, Transformation<Bitmap> bitmapTransformation) {
        this(bitmapTransformation, new GifDrawableTransformation(bitmapTransformation, bitmapPool));
    }

    GifBitmapWrapperTransformation(Transformation<Bitmap> bitmapTransformation, Transformation<GifDrawable> gifDataTransformation) {
        this.bitmapTransformation = bitmapTransformation;
        this.gifDataTransformation = gifDataTransformation;
    }

    @Override
    public Resource<GifBitmapWrapper> transform(Resource<GifBitmapWrapper> resource, int outWidth, int outHeight) {
        Resource<GifDrawable> transformed;
        Resource<Bitmap> bitmapResource = resource.get().getBitmapResource();
        Resource<GifDrawable> gifResource = resource.get().getGifResource();
        if (bitmapResource != null && this.bitmapTransformation != null) {
            Resource<Bitmap> transformed2 = this.bitmapTransformation.transform(bitmapResource, outWidth, outHeight);
            if (!bitmapResource.equals(transformed2)) {
                GifBitmapWrapper gifBitmap = new GifBitmapWrapper(transformed2, resource.get().getGifResource());
                return new GifBitmapWrapperResource(gifBitmap);
            }
        } else if (gifResource != null && this.gifDataTransformation != null && !gifResource.equals(transformed = this.gifDataTransformation.transform(gifResource, outWidth, outHeight))) {
            GifBitmapWrapper gifBitmap = new GifBitmapWrapper(resource.get().getBitmapResource(), transformed);
            return new GifBitmapWrapperResource(gifBitmap);
        }
        return resource;
    }

    @Override
    public String getId() {
        return this.bitmapTransformation.getId();
    }
}

