/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.glide.signature;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.core.ui.glide.load.Key;
import net.aihelp.core.ui.glide.signature.StringSignature;

public final class ApplicationVersionSignature {
    private static final ConcurrentHashMap<String, Key> PACKAGE_NAME_TO_KEY = new ConcurrentHashMap();

    public static Key obtain(Context context) {
        Key toAdd;
        String packageName = context.getPackageName();
        Key result = PACKAGE_NAME_TO_KEY.get(packageName);
        if (result == null && (result = PACKAGE_NAME_TO_KEY.putIfAbsent(packageName, toAdd = ApplicationVersionSignature.obtainVersionSignature(context))) == null) {
            result = toAdd;
        }
        return result;
    }

    static void reset() {
        PACKAGE_NAME_TO_KEY.clear();
    }

    private static Key obtainVersionSignature(Context context) {
        PackageInfo pInfo = null;
        try {
            pInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        String versionCode = pInfo != null ? String.valueOf(pInfo.versionCode) : UUID.randomUUID().toString();
        return new StringSignature(versionCode);
    }

    private ApplicationVersionSignature() {
    }
}

