/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.ui.loading.helper;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import net.aihelp.core.ui.loading.helper.VaryViewHelper;
import net.aihelp.utils.ResResolver;

public class VaryViewHelperController {
    private Context mContext;
    private final VaryViewHelper helper;

    public VaryViewHelperController(View view) {
        this(new VaryViewHelper(view));
        this.mContext = view.getContext();
    }

    private VaryViewHelperController(VaryViewHelper helper) {
        this.helper = helper;
    }

    public void showLoading(String msg) {
        View layout = this.helper.inflate(ResResolver.getLayoutId("aihelp_layout_progress_loading"));
        ProgressBar progressBar = (ProgressBar)layout.findViewById(ResResolver.getViewId("aihelp_loading_progress"));
        if (Build.VERSION.SDK_INT < 21) {
            Drawable drawable = progressBar.getIndeterminateDrawable().mutate();
            drawable.setColorFilter(ContextCompat.getColor((Context)this.mContext, (int)ResResolver.getColorId("aihelp_color_main")), PorterDuff.Mode.SRC_IN);
            progressBar.setIndeterminateDrawable(drawable);
        }
        TextView textView = (TextView)layout.findViewById(ResResolver.getViewId("aihelp_loading_msg"));
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            textView.setText((CharSequence)msg);
        } else {
            textView.setVisibility(8);
        }
        this.helper.showLayout(layout);
    }

    public void showEmpty(int ... layoutId) {
        if (layoutId != null && layoutId.length > 0) {
            View layout = this.helper.inflate(layoutId[0]);
            this.helper.showLayout(layout);
        }
    }

    public void showEmpty(View view) {
        if (view != null) {
            this.helper.showLayout(view);
        }
    }

    public void showNetworkError() {
        View layout = this.helper.inflate(ResResolver.getLayoutId("aihelp_layout_network_err"));
        TextView tvTitle = (TextView)layout.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        tvTitle.setText((CharSequence)ResResolver.getString("aihelp_network_error_msg"));
        TextView tvSubTitle = (TextView)layout.findViewById(ResResolver.getViewId("aihelp_tv_sub_title"));
        tvSubTitle.setText((CharSequence)ResResolver.getString("aihelp_network_no_connect"));
        this.helper.showLayout(layout);
    }

    public void restore() {
        this.helper.restoreView();
    }

    public boolean isViewRestored() {
        return this.helper.isViewRestored();
    }
}

