/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.bus;

import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.PendingPost;
import net.aihelp.core.util.bus.PendingPostQueue;
import net.aihelp.core.util.bus.Poster;
import net.aihelp.core.util.bus.Subscription;

class AsyncPoster
implements Runnable,
Poster {
    private final PendingPostQueue queue;
    private final EventBus eventBus;

    AsyncPoster(EventBus eventBus) {
        this.eventBus = eventBus;
        this.queue = new PendingPostQueue();
    }

    @Override
    public void enqueue(Subscription subscription, Object event) {
        PendingPost pendingPost = PendingPost.obtainPendingPost(subscription, event);
        this.queue.enqueue(pendingPost);
        this.eventBus.getExecutorService().execute(this);
    }

    @Override
    public void run() {
        PendingPost pendingPost = this.queue.poll();
        if (pendingPost == null) {
            throw new IllegalStateException("No pending post available");
        }
        this.eventBus.invokeSubscriber(pendingPost);
    }
}

