/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import net.aihelp.core.util.concurrent.AIHelpThreadFactory;

public class DispatchQueue {
    private static final String TAG = "AIHelp_DispatchQueue";
    private LinkedBlockingQueue<Future> tasks = new LinkedBlockingQueue();
    private LinkedBlockingQueue<Thread> afterThreads = new LinkedBlockingQueue();
    private ExecutorService threadPoolExecutor;

    public DispatchQueue(boolean isConcurrent) {
        if (isConcurrent) {
            AIHelpThreadFactory threadFactory = new AIHelpThreadFactory("cmdpq-a");
            this.threadPoolExecutor = Executors.newCachedThreadPool(threadFactory);
        } else {
            AIHelpThreadFactory threadFactory = new AIHelpThreadFactory("cmdpq-b");
            this.threadPoolExecutor = Executors.newSingleThreadExecutor(threadFactory);
        }
    }

    public void dispatchSync(Runnable runnable) {
        Future<?> taskFuture = this.threadPoolExecutor.submit(runnable);
        try {
            taskFuture.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void trackTask(Future task) {
        this.tasks.add(task);
    }

    public void dispatchAsync(Runnable runnable) {
        Future<?> task = this.threadPoolExecutor.submit(runnable);
        this.trackTask(task);
    }

    public void dispatchAfter(final Runnable runnable, final long interval) {
        Thread triggerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(interval);
                    DispatchQueue.this.dispatchAsync(runnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }, "HS-cmdpq-trig");
        triggerThread.start();
        this.afterThreads.add(triggerThread);
    }

    public void join() {
        try {
            for (Thread t : this.afterThreads) {
                t.join();
            }
            for (Future task : this.tasks) {
                task.get();
            }
            this.tasks.clear();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }
}

