/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.core.util.permission;

import android.app.Activity;
import android.content.Context;
import androidx.fragment.app.Fragment;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.core.util.permission.PermissionHelper;
import net.aihelp.core.util.permission.RequestAlertHelper;

public class AIHelpPermissions {
    private Activity activity;
    private Fragment fragment;
    private Object handler;
    private int requestCode = 0;
    private String[] permissions;
    private PermissionHelper helper;

    private AIHelpPermissions() {
    }

    public AIHelpPermissions setActivity(Activity activity) {
        this.activity = activity;
        return this;
    }

    public AIHelpPermissions setFragment(Fragment fragment) {
        this.fragment = fragment;
        return this;
    }

    public AIHelpPermissions setPermissionHandler(Object handler) {
        this.handler = handler;
        return this;
    }

    public AIHelpPermissions setRequestPermission(String ... permissions) {
        this.permissions = permissions;
        return this;
    }

    public AIHelpPermissions setRequestCode(int requestCode) {
        this.requestCode = requestCode;
        return this;
    }

    public void request(Context context, int requestType) {
        Permission.State[] states;
        this.helper = PermissionHelper.getInstance(this.activity, this.fragment, this.handler, this.permissions, this.requestCode, requestType);
        for (Permission.State state : states = this.helper.checkPermissionState()) {
            switch (state) {
                case AVAILABLE: {
                    this.helper.invokePermissionCallback(Permission.Result.GRANTED);
                    break;
                }
                case UNAVAILABLE: {
                    this.helper.invokePermissionCallback(Permission.Result.NONE);
                    break;
                }
                case RATIONAL: {
                    this.helper.invokePermissionCallback(Permission.Result.RATIONAL);
                    break;
                }
                case ASKABLE: {
                    RequestAlertHelper.request(context, this.helper);
                }
            }
            this.helper.setInvokeId(this.requestCode);
        }
    }

    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        if (this.helper != null) {
            this.helper.onRequestPermissionsResult(permissions, grantResults);
        }
    }

    public void recycle() {
        this.activity = null;
        this.fragment = null;
        this.handler = null;
        if (this.helper != null) {
            this.helper.recycle();
            this.helper = null;
        }
    }

    public static AIHelpPermissions getInstance() {
        return AIHelpPermissionsHolder.sInstance;
    }

    private static final class AIHelpPermissionsHolder {
        static final AIHelpPermissions sInstance = new AIHelpPermissions();

        private AIHelpPermissionsHolder() {
        }
    }
}

