/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.attachment;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.UUID;
import net.aihelp.common.CustomConfig;

public class AttachmentHelper {
    public static Intent getIntentForMedia(int attachmentType) {
        Intent mediaIntent = Build.VERSION.SDK_INT >= 19 ? new Intent("android.intent.action.OPEN_DOCUMENT") : new Intent("android.intent.action.GET_CONTENT");
        mediaIntent.addCategory("android.intent.category.OPENABLE");
        mediaIntent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        mediaIntent.addFlags(1);
        return AttachmentHelper.setupMimeTypeForIntent(mediaIntent, attachmentType);
    }

    public static Intent setupMimeTypeForIntent(Intent intent, int attachmentType) {
        String targetTypes = "";
        switch (attachmentType) {
            case 1: {
                String mediaTypes = String.format("%s,%s", CustomConfig.UploadLimit.imageTypes, CustomConfig.UploadLimit.videoTypes);
                targetTypes = AttachmentHelper.getMIMEType(mediaTypes).trim();
                break;
            }
            case 2: {
                targetTypes = AttachmentHelper.getMIMEType(CustomConfig.UploadLimit.fileTypes).trim();
                break;
            }
            case 3: {
                targetTypes = AttachmentHelper.getMIMEType(CustomConfig.UploadLimit.rpaAttachmentTypes).trim();
            }
        }
        if (!TextUtils.isEmpty((CharSequence)targetTypes)) {
            intent.setType(targetTypes);
            if (Build.VERSION.SDK_INT >= 19) {
                intent.putExtra("android.intent.extra.MIME_TYPES", targetTypes.split(" "));
            }
        }
        return intent;
    }

    public static String getMIMEType(String extension) {
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            StringBuilder mimeTypeBuilder = new StringBuilder();
            String[] fileExtensions = extension.split(",");
            if (fileExtensions.length > 0) {
                for (String fileExtension : fileExtensions) {
                    String mimeTypeFromExtension;
                    if (TextUtils.isEmpty((CharSequence)fileExtension) || TextUtils.isEmpty((CharSequence)(mimeTypeFromExtension = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension)))) continue;
                    mimeTypeBuilder.append(mimeTypeFromExtension).append(" ");
                }
                return mimeTypeBuilder.toString();
            }
        }
        return "image/jpeg image/png";
    }

    public static File getCopiedUriFile(Context context, Uri uri) {
        try {
            int read;
            File file;
            int columnIndex;
            context.grantUriPermission(context.getPackageName(), uri, 1);
            String displayName = UUID.randomUUID().toString();
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null && cursor.moveToFirst() && (columnIndex = cursor.getColumnIndex("_display_name")) > 0) {
                displayName = cursor.getString(columnIndex);
            }
            if ((file = new File(context.getCacheDir(), displayName)).exists()) {
                return file;
            }
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] buffers = new byte[8192];
            while ((read = inputStream.read(buffers)) != -1) {
                outputStream.write(buffers, 0, read);
            }
            if (cursor != null) {
                cursor.close();
            }
            inputStream.close();
            outputStream.close();
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

