/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.local;

import android.content.Context;
import android.text.TextUtils;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.UserConfig;
import net.aihelp.core.mvp.AbsRepository;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.LocaleUtil;

public class InitRepository
extends AbsRepository {
    public InitRepository(Context context) {
        super(context);
    }

    public void saveInitConfig(String appKey, String domain, String appId, String initLanguage) {
        Const.APP_KEY = appKey;
        API.HOST_URL = DomainSupportHelper.getOptimizedDomain(domain);
        Const.APP_ID = appId;
        if (!TextUtils.isEmpty((CharSequence)initLanguage)) {
            Const.ORIGINAL_LANGUAGE = LocaleUtil.getFormatLanguage(initLanguage);
        }
        Const.CORRECT_LANGUAGE = Const.ORIGINAL_LANGUAGE;
        UserProfile.resetUserProfile(this.mContext);
    }

    public void saveUserProfileConfig(UserConfig config) {
        UserProfile.USER_ID = Const.TOGGLE_DISTINGUISH_USER_BY_DEVICE ? String.format("%s|%s", DeviceUuidFactory.id(this.mContext), config.getUserId()) : config.getUserId();
        UserProfile.USER_NAME = config.getUserName();
        UserProfile.SERVER_ID = config.getServerId();
        UserProfile.CUSTOM_DATA = config.getFormatCustomData();
    }

    public void setUploadLogPath(String logPath) {
        Const.LOG_UPLOAD_PATH = logPath;
    }

    public void setNetworkCheckHostAddress(String hostAddress) {
        Const.NET_CHECK_HOST = hostAddress;
    }

    public void saveCrmInfo(String userId, String userTags) {
        this.doSave("crmInfo_" + userId, String.format("%s|%s", userId, userTags));
    }

    public void saveMqttPushInfo(String pushToken, int pushPlatform) {
        Const.PUSH_INFO = String.format("%s|%s", pushToken, pushPlatform);
    }
}

