/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize;

import android.text.TextUtils;
import androidx.annotation.RestrictTo;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.data.localize.config.CommonTextHelper;
import net.aihelp.data.localize.config.InitBusinessHelper;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.localize.config.StyleSheetHelper;
import net.aihelp.data.localize.config.TemplateBusinessHelper;
import net.aihelp.data.localize.config.UploadLimitHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.localize.data.LocaleStringHelper;
import net.aihelp.data.localize.data.RpaPredictionHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.track.resource.ResourceTracker;
import net.aihelp.init.InitHelper;
import net.aihelp.utils.FileUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class LocalizeHelper {
    public static final int FETCH_SOURCE_INIT = 1;
    public static final int FETCH_SOURCE_TEMPLATE = 2;
    public static final int MODE_FAQ_SECTION = 1;
    public static final int MODE_RPA_PREDICTION = 2;
    public static final int MODE_INIT_LOCALE = 11;
    public static final int MODE_INIT_PROCESS = 12;
    public static final int MODE_INIT_UPLOAD_LIMIT = 13;
    public static final int MODE_INIT_TEXT = 14;
    public static final int MODE_INIT_BUSINESS_LOGIC = 15;
    public static final int MODE_TEMPLATE_STYLE_SHEET = 21;
    public static final int MODE_TEMPLATE_BUSINESS_LOGIC = 22;
    public static final int MODE_TEMPLATE_FAQ_HOT_TOPIC = 23;
    public static final int MODE_TEMPLATE_TEXT = 24;
    public static final int MODE_SAMPLING_FILE = 100;

    public static void resetLocalizeData() {
        FaqHelper.INSTANCE.reset();
        LocaleStringHelper.INSTANCE.reset();
        CommonTextHelper.INSTANCE.reset();
        ProcessEntranceHelper.INSTANCE.reset();
        UploadLimitHelper.INSTANCE.reset();
        RpaPredictionHelper.INSTANCE.reset();
    }

    private static List<Integer> getModeList(int fetchSource) {
        ArrayList<Integer> modeList = new ArrayList<Integer>();
        if (fetchSource == 1) {
            if (Const.TOGGLE_LOCALIZE_VIA_INIT || LocalizeUtil.isAlreadyLocalized(1)) {
                modeList.add(1);
            }
            modeList.add(2);
            modeList.add(11);
            modeList.add(14);
            modeList.add(13);
            modeList.add(15);
            modeList.add(12);
            modeList.add(100);
        }
        if (fetchSource == 2) {
            if (!LocalizeUtil.isAlreadyLocalized(1)) {
                modeList.add(1);
            }
            modeList.add(23);
            modeList.add(22);
            modeList.add(21);
            modeList.add(24);
        }
        return modeList;
    }

    public static List<Integer> getLocalizeResourceList(int fetchSource) {
        List<Integer> modeList = LocalizeHelper.getModeList(fetchSource);
        Iterator<Integer> iterator = modeList.iterator();
        while (iterator.hasNext()) {
            Integer next = iterator.next();
            if (!LocalizeUtil.isAlreadyLocalized(next)) continue;
            LocalizeHelper.prepareDataSourceByMode(next, fetchSource);
            iterator.remove();
        }
        return modeList;
    }

    public static void goFetchLocalizeData(int fetchSource) {
        List<Integer> localizeList = LocalizeHelper.getLocalizeResourceList(fetchSource);
        ResourceTracker.onResourceRequested(localizeList.size(), fetchSource);
        for (int i = 0; i < localizeList.size(); ++i) {
            LocalizeHelper.getLocalizeDataFromUrl(localizeList.get(i), fetchSource);
        }
    }

    public static void getLocalizeDataFromUrl(final int mode, final int fetchSource) {
        if (mode == 1 && FaqHelper.isFaqDataAlreadyPrepared()) {
            return;
        }
        AIHelpRequest.getInstance().requestDownloadFile(mode, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String result) {
                LocalizeHelper.prepareDataSourceByMode(mode, fetchSource);
                ResourceTracker.onResourceRetrieved(mode, true, fetchSource);
            }

            @Override
            public void onAsyncFailure(String url, int errorCode, String errorMsg) {
                ResourceTracker.onResourceRetrieved(mode, false, fetchSource);
                switch (mode) {
                    case 1: {
                        LocalizeHelper.getDataAfterLocalizeFailed();
                        break;
                    }
                    case 12: {
                        if (TextUtils.isEmpty((CharSequence)url)) {
                            errorMsg = "Failed downloading custom entrance configuration, please checkout your configuration in AIHelp Dashboard and re-publish.";
                        }
                        InitHelper.getInstance().onAIHelpInitializedCallback(false, errorMsg);
                        break;
                    }
                }
            }
        });
    }

    private static void prepareDataSourceByMode(int mode, int fetchSource) {
        switch (mode) {
            case 1: {
                FaqHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 2: {
                RpaPredictionHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 14: 
            case 24: {
                CommonTextHelper.INSTANCE.prepareDataSource(mode);
                break;
            }
            case 11: {
                LocaleStringHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 12: {
                ProcessEntranceHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 13: {
                UploadLimitHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 15: {
                InitBusinessHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 21: {
                StyleSheetHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 22: {
                TemplateBusinessHelper.INSTANCE.prepareDataSource();
                break;
            }
            case 23: {
                FaqHelper.INSTANCE.prepareNotificationAndHotTopics();
                break;
            }
        }
    }

    private static void getDataAfterLocalizeFailed() {
        AIHelpRequest.getInstance().requestGetByAsync(API.FAQ_URL, null, new ReqCallback<String>(){

            @Override
            public void onAsyncReqSuccess(String str) {
                try {
                    boolean success;
                    if (!TextUtils.isEmpty((CharSequence)str) && (success = FileUtil.writeFileToDisk(new ByteArrayInputStream(str.getBytes()), LocalizeUtil.getFileLocation(1)))) {
                        FaqHelper.INSTANCE.prepareDataSource();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

