/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.InitBusinessEntity;
import net.aihelp.utils.FileUtil;

public enum InitBusinessHelper {
    INSTANCE;


    public void prepareDataSource() {
        try {
            InitBusinessEntity logicEntity;
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(15));
            if (!TextUtils.isEmpty((CharSequence)content) && (logicEntity = JsonHelper.toJavaObject(content, InitBusinessEntity.class)) != null) {
                CustomConfig.InitSetting.screenOrientation = logicEntity.getDirection();
                CustomConfig.InitSetting.privacyControlData = logicEntity.getInformation();
                if (logicEntity.getFaqEvaluation() != null) {
                    CustomConfig.InitSetting.isEvaluationForBotEnable = logicEntity.getFaqEvaluation().isOnlineValid();
                    CustomConfig.InitSetting.isEvaluationForAnswerPageEnable = logicEntity.getFaqEvaluation().isFaqDetailValid();
                    CustomConfig.InitSetting.isFaqUnhelpfulFeedbackEnable = logicEntity.getFaqEvaluation().isSuggestionValid();
                    CustomConfig.InitSetting.isEvaluationForOperationEnable = logicEntity.getFaqEvaluation().isOperateDetailValid();
                }
                if (logicEntity.getSatisfied() != null) {
                    CustomConfig.InitSetting.isEvaluateBadServiceEnable = logicEntity.getSatisfied().isFeedback();
                    CustomConfig.InitSetting.csEvaluateMaxCount = logicEntity.getSatisfied().getFeedbackMax();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

