/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.common.API;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.IntentEntity;
import net.aihelp.data.model.config.ProcessEntity;
import net.aihelp.data.model.init.InitEntity;
import net.aihelp.data.track.resource.tracker.TemplateResTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.init.InitHelper;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.TLog;
import org.json.JSONArray;
import org.json.JSONObject;

public enum ProcessEntranceHelper {
    INSTANCE;

    private final Map<String, ProcessEntity> processMap = new ConcurrentHashMap<String, ProcessEntity>();
    private ProcessEntity currentProcess;
    private int placeholderTemplateId;
    private String placeholderCsEntrance;

    public void reset() {
        this.currentProcess = null;
        this.processMap.clear();
        TemplateResTracker.INSTANCE.reset();
    }

    public void prepareDataSource() {
        String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(12));
        if (!TextUtils.isEmpty((CharSequence)content)) {
            JSONArray jsonArray = JsonHelper.getJsonArray(content);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                String processId = JsonHelper.optString(jsonObject, "processId");
                ProcessEntity processEntity = new ProcessEntity();
                processEntity.setEntranceId(processId);
                processEntity.setIntent(jsonObject.optInt("homeSettings"));
                processEntity.setFaqId(JsonHelper.optString(jsonObject, "faqId"));
                processEntity.setSectionId(JsonHelper.optString(jsonObject, "faqId"));
                processEntity.setVisitId(JsonHelper.optString(jsonObject, "id"));
                processEntity.setTags(JsonHelper.getJsonArray(jsonObject, "tags"));
                processEntity.setFaqEntrances(JsonHelper.getJsonArray(jsonObject, "location"));
                JSONObject intentsMenu = JsonHelper.getJsonObject(jsonObject, "intentsMenu");
                processEntity.setEnableInteraction(intentsMenu.optBoolean("alwaysShow"));
                processEntity.setSmartIntentName(JsonHelper.optString(intentsMenu, "menuText"));
                processEntity.setSmartIntentList(this.getBindingIntent(intentsMenu));
                boolean isDefaultEntrance = jsonObject.optInt("isDefault") == 1;
                int templateId = jsonObject.optInt("templateId");
                JSONArray textSetting = JsonHelper.getJsonArray(jsonObject, "textSetting");
                JSONObject textSettingObject = JsonHelper.getJsonObject(textSetting, 0);
                String entranceText = JsonHelper.optString(textSettingObject, "content");
                if (isDefaultEntrance) {
                    this.placeholderTemplateId = templateId;
                    this.placeholderCsEntrance = entranceText;
                }
                processEntity.setTemplateId(templateId);
                processEntity.setCsEntrance(entranceText);
                this.processMap.put(processId, processEntity);
            }
            InitHelper.getInstance().onAIHelpInitializedCallback(true, "");
        }
    }

    public ProcessEntity getCurrentProcess() {
        if (this.currentProcess == null) {
            return new ProcessEntity();
        }
        return this.currentProcess;
    }

    private List<IntentEntity> getBindingIntent(JSONObject jsonObject) {
        ArrayList<IntentEntity> intentList = new ArrayList<IntentEntity>();
        JSONArray intentsList = JsonHelper.getJsonArray(jsonObject, "intentsList");
        if (intentsList.length() > 0) {
            for (int i = 0; i < intentsList.length(); ++i) {
                JSONObject intentObject = JsonHelper.getJsonObject(intentsList, i);
                IntentEntity intentEntity = new IntentEntity();
                intentEntity.setIntentId(intentObject.optInt("intentsId"));
                intentEntity.setIntentName(JsonHelper.optString(intentObject, "name"));
                intentEntity.setIntentList(this.getBindingIntent(intentObject));
                intentList.add(intentEntity);
            }
        }
        return intentList;
    }

    public ProcessEntity getProcess(String id2) {
        ProcessEntity processEntity = this.processMap.get(id2);
        if (processEntity == null) {
            processEntity = new ProcessEntity();
            processEntity.setEntranceId(id2);
            processEntity.setTemplateId(this.placeholderTemplateId);
            if ("test001".equals(id2)) {
                processEntity.setIntent(1);
            } else if ("test002".equals(id2)) {
                processEntity.setIntent(2);
            } else if ("test003".equals(id2)) {
                processEntity.setIntent(3);
            } else if ("test004".equals(id2)) {
                processEntity.setIntent(4);
            } else {
                TLog.d("No related process was found, please check your process id.");
            }
        }
        if (this.currentProcess == null || !this.currentProcess.getTemplateId().equals(processEntity.getTemplateId())) {
            this.fetchTemplateData(processEntity);
        }
        if (!TextUtils.isEmpty((CharSequence)processEntity.getCsEntrance())) {
            CustomConfig.HelpCenter.faqCSEntranceText = processEntity.getCsEntrance();
        }
        processEntity.setTrackActiveId(UUID.randomUUID().toString());
        UserProfile.ENTRANCE_TAGS = processEntity.getTags();
        this.currentProcess = processEntity;
        this.handleTrackLogic(processEntity);
        return processEntity;
    }

    public void fetchPlaceholderTemplateData() {
        ProcessEntity processEntity = new ProcessEntity();
        processEntity.setTemplateId(this.placeholderTemplateId);
        processEntity.setCsEntrance(this.placeholderCsEntrance);
        this.fetchTemplateData(processEntity);
        if (!TextUtils.isEmpty((CharSequence)processEntity.getCsEntrance())) {
            CustomConfig.HelpCenter.faqCSEntranceText = processEntity.getCsEntrance();
        }
    }

    private void fetchTemplateData(ProcessEntity process) {
        InitEntity initEntity = InitHelper.getInstance().getInitEntity();
        if (initEntity != null && initEntity.getSdkTemplate() != null && process != null) {
            TemplateResTracker.INSTANCE.reset();
            CustomConfig.resetTemplateResources();
            JSONObject templateObject = JsonHelper.getJsonObject(initEntity.getSdkTemplate(), process.getTemplateId());
            API.CONFIG_TEMPLATE_BUSINESS_LOGIC = JsonHelper.optString(templateObject, "business");
            API.CONFIG_TEMPLATE_STYLE_SHEET = JsonHelper.optString(templateObject, "style");
            API.CONFIG_TEMPLATE_TEXT = JsonHelper.optString(templateObject, "text");
            API.CONFIG_TEMPLATE_FAQ_HOT_TOPIC = JsonHelper.optString(templateObject, "faq");
            LocalizeHelper.goFetchLocalizeData(2);
        }
    }

    private void handleTrackLogic(ProcessEntity processEntity) {
        if (processEntity != null) {
            StatisticTracker tracker = StatisticTracker.getInstance();
            tracker.setupTrackHandler(processEntity.getEntranceId(), processEntity.getTrackActiveId());
            switch (processEntity.getIntent()) {
                case 1: 
                case 2: 
                case 3: {
                    tracker.showAIHelp();
                    tracker.showHelpCenter();
                    break;
                }
                case 4: {
                    tracker.showAIHelp();
                    tracker.showCustomerService(true);
                }
            }
        }
    }
}

