/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.config;

import android.text.TextUtils;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.StyleSheetEntity;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FileUtil;

public enum StyleSheetHelper {
    INSTANCE;


    public void prepareDataSource() {
        try {
            StyleSheetEntity styleEntity;
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(21));
            if (!TextUtils.isEmpty((CharSequence)content) && (styleEntity = JsonHelper.toJavaObject(content, StyleSheetEntity.class)) != null) {
                this.prepareCommonConfig(styleEntity.getGeneral());
                this.prepareHelpCenterConfig(styleEntity.getHelp());
                this.prepareCustomerServiceConfig(styleEntity.getOnLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCustomerServiceConfig(StyleSheetEntity.OnLineEntity entity) {
        CustomConfig.CustomerService.csNavigationBarTitleIcon = this.getAdjustedUrl(entity.getNavBar());
        CustomConfig.CustomerService.csBotSupportPortrait = this.getAdjustedUrl(entity.getRobotImgUrl());
        CustomConfig.CustomerService.csManualSupportPortrait = this.getAdjustedUrl(entity.getCustomerImgUrl());
        CustomConfig.CustomerService.csUserPortrait = this.getAdjustedUrl(entity.getUserImgUrl());
    }

    private void prepareHelpCenterConfig(StyleSheetEntity.HelpEntity entity) {
        CustomConfig.HelpCenter.faqNavigationBarTitleIcon = this.getAdjustedUrl(entity.getNavBar());
        CustomConfig.HelpCenter.faqNotificationIcon = this.getAdjustedUrl(entity.getNoticeBar());
        CustomConfig.HelpCenter.faqHotTopicTitleIcon = this.getAdjustedUrl(entity.getFaqList());
        CustomConfig.HelpCenter.faqSectionTitleIcon = this.getAdjustedUrl(entity.getFaqSectionList());
    }

    private void prepareCommonConfig(StyleSheetEntity.GeneralEntity entity) {
        if (entity.getNavBar() != null) {
            CustomConfig.CommonSetting.navigationBarBackground = entity.getNavBar().getColor();
            CustomConfig.CommonSetting.navigationBarAlpha = entity.getNavBar().getTransparency();
        }
        CustomConfig.CommonSetting.backgroundColorForAll = entity.getVertical();
        CustomConfig.CommonSetting.backgroundImageForPortrait = this.getAdjustedUrl(entity.getVerticalImgUrl());
        CustomConfig.CommonSetting.backgroundImageForLandscape = this.getAdjustedUrl(entity.getHorizontalImgUrl());
        if (entity.getFrontColor() != null) {
            CustomConfig.CommonSetting.upperBackgroundColor = entity.getFrontColor().getColor();
            CustomConfig.CommonSetting.upperBackgroundAlpha = entity.getFrontColor().getTransparency();
        }
        CustomConfig.CommonSetting.textColor = entity.getTextColor();
        CustomConfig.CommonSetting.highlightedColor = entity.getHighlightColor();
        CustomConfig.CommonSetting.interactElementTextColor = entity.getButtonColor();
        CustomConfig.CommonSetting.scaleFactor = (float)Math.min(Math.max(1.0, entity.getFontSize()), 2.0);
    }

    private String getAdjustedUrl(String originUrl) {
        return DomainSupportHelper.getAdjustedUrl(originUrl);
    }
}

