/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.data;

import android.os.Build;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.http.config.HttpConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.faq.FaqContentEntity;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.utils.FileUtil;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import org.json.JSONArray;
import org.json.JSONObject;

public enum FaqHelper {
    INSTANCE;

    public static final String FAQ_NOTIFICATION = "faqNotification";
    public static final String FAQ_HOT_TOPICS = "faqHotTopics";
    private static boolean isDataSourcePrepared;
    private JSONArray rawFlatFaqArray = new JSONArray();
    private final Map<String, JSONArray> rawFaqMap = new ConcurrentHashMap<String, JSONArray>();
    private final List<FaqListEntity> rootSections = new ArrayList<FaqListEntity>();
    private final Map<String, List<FaqListEntity>> subSectionsMap = new ConcurrentHashMap<String, List<FaqListEntity>>();
    private final Map<String, List<FaqListEntity>> faqQuestionsMap = new ConcurrentHashMap<String, List<FaqListEntity>>();

    public static boolean isFaqDataAlreadyPrepared() {
        return LocalizeUtil.isAlreadyLocalized(1) && isDataSourcePrepared;
    }

    public JSONArray getRawFlatFaqArray() {
        return this.rawFlatFaqArray;
    }

    public JSONArray getRawNotification() {
        return this.rawFaqMap.get(FAQ_NOTIFICATION);
    }

    public JSONArray getRawHotTopics() {
        return this.rawFaqMap.get(FAQ_HOT_TOPICS);
    }

    public List<FaqListEntity> getRootSections() {
        return ListUtil.getSafeList(this.rootSections);
    }

    public List<FaqListEntity> getSubSections(String sectionId) {
        return ListUtil.getSafeList(this.subSectionsMap.get(sectionId));
    }

    public List<FaqListEntity> getQuestionList(String sectionId) {
        return ListUtil.getSafeList(this.faqQuestionsMap.get(sectionId));
    }

    public void reset() {
        this.rawFaqMap.clear();
        this.rawFlatFaqArray = new JSONArray();
        this.rootSections.clear();
        this.subSectionsMap.clear();
        this.faqQuestionsMap.clear();
        Const.FAQ_FILE = "";
        isDataSourcePrepared = false;
    }

    public void resetHotTopicAndNotification() {
        this.faqQuestionsMap.remove(FAQ_HOT_TOPICS);
        this.faqQuestionsMap.remove(FAQ_NOTIFICATION);
        this.rawFaqMap.remove(FAQ_HOT_TOPICS);
        this.rawFaqMap.remove(FAQ_NOTIFICATION);
        for (int i = this.rawFlatFaqArray.length() - 1; i >= 0; --i) {
            JSONObject rawFaq = JsonHelper.getJsonObject(this.rawFlatFaqArray, i);
            String templateSectionId = JsonHelper.optString(rawFaq, "templateSectionId");
            if (!templateSectionId.equals(FAQ_HOT_TOPICS) && !templateSectionId.equals(FAQ_NOTIFICATION) || Build.VERSION.SDK_INT < 19) continue;
            this.rawFlatFaqArray.remove(i);
        }
    }

    public synchronized void prepareDataSource() {
        this.prepareDataSource(null);
    }

    public synchronized void prepareDataSource(final Runnable callback) {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(1));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONArray rawSectionArray = JsonHelper.getJsonArray(new JSONObject(content), "faqlist");
                this.prepareRootSectionList(rawSectionArray);
                this.prepareSubSectionsMap(rawSectionArray);
                this.prepareFaqQuestionsMap(rawSectionArray);
                this.flatRawFaqJsonArray(rawSectionArray);
            }
            if (callback != null) {
                ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        callback.run();
                    }
                });
            }
            isDataSourcePrepared = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void prepareNotificationAndHotTopics() {
        try {
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(23));
            if (!TextUtils.isEmpty((CharSequence)content)) {
                JSONObject faq;
                int i;
                JSONObject jsonObject = new JSONObject(content);
                if (CustomConfig.HelpCenter.isFaqNotificationVisible) {
                    JSONArray notificationArray = JsonHelper.getJsonArray(jsonObject, "notice");
                    ArrayList<FaqListEntity> notificationQuestions = new ArrayList<FaqListEntity>();
                    for (i = 0; i < notificationArray.length(); ++i) {
                        faq = JsonHelper.getJsonObject(notificationArray, i);
                        faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                        faq.put("templateSectionId", (Object)FAQ_NOTIFICATION);
                        notificationQuestions.add(this.getFaqListEntity(5, faq));
                        this.rawFlatFaqArray.put((Object)faq);
                    }
                    this.faqQuestionsMap.put(FAQ_NOTIFICATION, notificationQuestions);
                    this.rawFaqMap.put(FAQ_NOTIFICATION, notificationArray);
                }
                if (CustomConfig.HelpCenter.isFaqHotTopicVisible) {
                    JSONArray faqListArray = JsonHelper.getJsonArray(jsonObject, "faqList");
                    ArrayList<FaqListEntity> hotTopicQuestions = new ArrayList<FaqListEntity>();
                    for (i = 0; i < faqListArray.length(); ++i) {
                        faq = JsonHelper.getJsonObject(faqListArray, i);
                        hotTopicQuestions.add(this.getFaqListEntity(6, faq));
                        faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                        faq.put("templateSectionId", (Object)FAQ_HOT_TOPICS);
                        this.rawFlatFaqArray.put((Object)faq);
                    }
                    this.faqQuestionsMap.put(FAQ_HOT_TOPICS, hotTopicQuestions);
                    this.rawFaqMap.put(FAQ_HOT_TOPICS, faqListArray);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FaqContentEntity getFaqById(String faqId) {
        return this.getFaqById(null, faqId);
    }

    public FaqContentEntity getFaqById(String sectionId, String faqId) {
        if (TextUtils.isEmpty((CharSequence)sectionId)) {
            return this.filterFaqById(this.rawFlatFaqArray, faqId);
        }
        return this.filterFaqById(this.rawFaqMap.get(sectionId), faqId);
    }

    public void afterFaqEvaluated(String faqId, long lastUpdateTime) {
        if (TextUtils.isEmpty((CharSequence)faqId)) {
            return;
        }
        String evaluatedFaqIds = SpUtil.getInstance().getString(this.getLanguageBasedKey());
        String evaluatedFaq = String.format("%s_%s", faqId, lastUpdateTime);
        SpUtil.getInstance().put(this.getLanguageBasedKey(), String.format("%s,%s", evaluatedFaqIds, evaluatedFaq));
    }

    public boolean shouldShowQuestionFooter(String faqId, long lastUpdateTime) {
        if (TextUtils.isEmpty((CharSequence)faqId)) {
            return false;
        }
        String evaluatedFaq = String.format("%s_%s", faqId, lastUpdateTime);
        return !SpUtil.getInstance().getString(this.getLanguageBasedKey()).contains(evaluatedFaq);
    }

    private void flatRawFaqJsonArray(JSONArray rawSectionArray) {
        try {
            for (int i = 0; i < rawSectionArray.length(); ++i) {
                JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
                JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
                if (faqs.length() == 0) {
                    faqs = JsonHelper.getJsonArray(section, "hiddenFaqs");
                }
                if (faqs.length() <= 0) continue;
                for (int j = 0; j < faqs.length(); ++j) {
                    JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                    faq.put("noHtmlContent", (Object)Styles.getNoTemplateFaqContent(faq.optString("content")));
                    faq.put("sectionName", (Object)JsonHelper.optString(section, "sectionName"));
                    faq.put("secImgUrl", (Object)JsonHelper.optString(section, "secImgUrl"));
                    faq.put("isHidden", section.optInt("isSectionHidden") == 1);
                    this.rawFlatFaqArray.put((Object)faq);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean shouldIgnoreCurrentEntity(FaqListEntity entity) {
        if (entity == null) {
            return true;
        }
        for (int j = 0; j < this.rootSections.size(); ++j) {
            FaqListEntity listEntity = this.rootSections.get(j);
            if (!listEntity.getId().equals(entity.getId())) continue;
            return true;
        }
        return false;
    }

    private void prepareRootSectionList(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            FaqListEntity entity;
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() <= 0) continue;
            String sectionBName = section.optString("sectionBName");
            if (!TextUtils.isEmpty((CharSequence)sectionBName)) {
                entity = new FaqListEntity(1, section.optString("sectionBId"), section.optString("sectionBName"));
                entity.setOrder(Integer.parseInt(section.optString("sectionBOrderNo")));
                entity.setIconUrl(section.optString("secParentImgUrl"));
                entity.setSectionName(section.optString("sectionBName"));
            } else {
                entity = new FaqListEntity(1, section.optString("sectionId"), section.optString("sectionName"));
                entity.setOrder(Integer.parseInt(section.optString("orderNo")));
                entity.setIconUrl(section.optString("secImgUrl"));
            }
            if (this.shouldIgnoreCurrentEntity(entity)) continue;
            this.rootSections.add(entity);
        }
        Collections.sort(this.rootSections);
    }

    private boolean isDuplicate(List<FaqListEntity> subSections, String sectionId) {
        for (int i = 0; i < subSections.size(); ++i) {
            FaqListEntity faqListEntity = subSections.get(i);
            if (faqListEntity == null || !faqListEntity.getId().equals(sectionId)) continue;
            return true;
        }
        return false;
    }

    public void prepareSubSectionsMap(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            JSONArray hiddenFaqs = JsonHelper.getJsonArray(section, "hiddenFaqs");
            if (faqs.length() <= 0 && hiddenFaqs.length() <= 0) continue;
            String parentSectionId = section.optString("sectionBId");
            String parentSectionName = section.optString("sectionBName");
            if (TextUtils.isEmpty((CharSequence)parentSectionName)) continue;
            List<FaqListEntity> subSections = this.subSectionsMap.get(parentSectionId);
            if (subSections == null) {
                subSections = new ArrayList<FaqListEntity>();
            }
            if (this.isDuplicate(subSections, section.optString("sectionId"))) continue;
            FaqListEntity entity = new FaqListEntity(2, section.optString("sectionId"), section.optString("sectionName"));
            entity.setIconUrl(section.optString("secImgUrl"));
            entity.setSectionName(parentSectionName);
            entity.setHidden(section.optInt("isSectionHidden") == 1);
            subSections.add(entity);
            this.subSectionsMap.put(parentSectionId, subSections);
        }
    }

    public boolean hasSubsections(String sectionId) {
        return this.subSectionsMap != null && this.subSectionsMap.containsKey(sectionId);
    }

    private void prepareFaqQuestionsMap(JSONArray rawSectionArray) {
        for (int i = 0; i < rawSectionArray.length(); ++i) {
            JSONObject section = JsonHelper.getJsonObject(rawSectionArray, i);
            JSONArray faqs = JsonHelper.getJsonArray(section, "faqs");
            if (faqs.length() == 0) {
                faqs = JsonHelper.getJsonArray(section, "hiddenFaqs");
            }
            if (faqs.length() <= 0) continue;
            String sectionId = section.optString("sectionId");
            boolean isSectionHidden = section.optInt("isSectionHidden") == 1;
            ArrayList<FaqListEntity> faqQuestions = new ArrayList<FaqListEntity>();
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                FaqListEntity faqListEntity = this.getFaqListEntity(3, faq);
                faqListEntity.setSectionName(section.optString("sectionName"));
                faqQuestions.add(faqListEntity);
            }
            this.faqQuestionsMap.put(sectionId, faqQuestions);
            this.rawFaqMap.put(sectionId, faqs);
        }
    }

    private FaqContentEntity filterFaqById(JSONArray faqs, String faqId) {
        if (faqs != null && faqs.length() > 0) {
            for (int j = 0; j < faqs.length(); ++j) {
                JSONObject faq = JsonHelper.getJsonObject(faqs, j);
                String displayId = faq.optString("faqId");
                String mainId = faq.optString("kmMainid");
                String contentId = faq.optString("kmContentId");
                if (!displayId.equals(faqId) && !mainId.equals(faqId) && !contentId.equals(faqId)) continue;
                return this.getFaqContentEntity(faq);
            }
        }
        return null;
    }

    private FaqListEntity getFaqListEntity(int displayType, JSONObject faq) {
        FaqListEntity entity = new FaqListEntity(displayType, faq.optString("kmMainid"), faq.optString("question"));
        entity.setIconUrl(JsonHelper.optString(faq, "imgUrl"));
        return entity;
    }

    private FaqContentEntity getFaqContentEntity(JSONObject faq) {
        FaqContentEntity faqEntity = new FaqContentEntity();
        faqEntity.setSectionName(JsonHelper.optString(faq, "sectionName"));
        faqEntity.setIconUrl(JsonHelper.optString(faq, "secImgUrl"));
        faqEntity.setFaqMainId(faq.optString("kmMainid"));
        faqEntity.setFaqDisplayId(faq.optString("faqId"));
        faqEntity.setFaqContentId(faq.optString("kmContentId"));
        faqEntity.setFaqTitle(faq.optString("question"));
        faqEntity.setFaqKeywords(faq.optString("keyWords"));
        faqEntity.setSimilarQuestions(faq.optString("similarQuestions"));
        faqEntity.setFaqContent(faq.optString("content"));
        faqEntity.setLastUpdateTime(faq.optLong("lastUpdateTime", 0L));
        faqEntity.setFaqNoHtmlContent(Styles.getNoTemplateFaqContent(faq.optString("content")));
        faqEntity.setFormTitle(JsonHelper.optString(faq, "formTitle"));
        faqEntity.setFormUrl(JsonHelper.optString(faq, "formUrl"));
        return faqEntity;
    }

    private String getLanguageBasedKey() {
        return HttpConfig.md5(String.format("%s_%s_%s", Const.APP_ID, Const.ORIGINAL_LANGUAGE, "evaluated_faqIds"));
    }
}

