/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.localize.util;

import android.text.TextUtils;
import java.io.File;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.TLog;

public class LocalizeUtil {
    public static boolean isFallbackUrl(int mode, String url) {
        return mode == 1 && url.endsWith(String.format("%s-from-api.json", Const.CORRECT_LANGUAGE));
    }

    public static String getFileLocation(int mode, String fileName) {
        File dirFile;
        String dirPath = "";
        File filesDir = AIHelpContext.getInstance().getContext().getFilesDir();
        if (filesDir != null && !(dirFile = new File(dirPath = filesDir.getAbsolutePath() + "/AIHelp" + LocalizeUtil.getFolderName(mode) + Const.CORRECT_LANGUAGE)).exists() && dirFile.mkdirs()) {
            return dirFile.getAbsolutePath() + File.separator + fileName;
        }
        return dirPath + File.separator + fileName;
    }

    public static String getFileLocation(int mode) {
        return LocalizeUtil.getFileLocation(mode, LocalizeUtil.getFileName(mode));
    }

    public static String getUrl(int mode) {
        switch (mode) {
            case 12: {
                return API.CONFIG_INIT_PROCESS;
            }
            case 14: {
                return API.CONFIG_INIT_TEXT;
            }
            case 13: {
                return API.CONFIG_INIT_UPLOAD_LIMIT;
            }
            case 11: {
                return API.CONFIG_INIT_LOCALE_FILE;
            }
            case 15: {
                return API.CONFIG_INIT_BUSINESS_LOGIC;
            }
            case 21: {
                return API.CONFIG_TEMPLATE_STYLE_SHEET;
            }
            case 22: {
                return API.CONFIG_TEMPLATE_BUSINESS_LOGIC;
            }
            case 23: {
                return API.CONFIG_TEMPLATE_FAQ_HOT_TOPIC;
            }
            case 24: {
                return API.CONFIG_TEMPLATE_TEXT;
            }
            case 2: {
                return API.CONFIG_RPA_PREDICTION;
            }
            case 100: {
                return API.SAMPLING_FILTER;
            }
        }
        return API.CDN_URL + LocalizeUtil.getFolderName(mode) + Const.APP_ID + File.separator + LocalizeUtil.getFileName(mode);
    }

    public static boolean isAlreadyLocalized(int mode) {
        try {
            String path = LocalizeUtil.getFileLocation(mode);
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
        }
        catch (Exception e) {
            TLog.d("LocalizeHelper check localize status failed.");
        }
        return false;
    }

    public static String getFolderName(int mode) {
        String middle = "";
        switch (mode) {
            case 1: {
                middle = "/FAQ/";
                break;
            }
            case 2: {
                middle = "/rpa-prediction/";
                break;
            }
            case 11: {
                middle = "/init-locale/";
                break;
            }
            case 12: {
                middle = "/init-process/";
                break;
            }
            case 14: {
                middle = "/init-text/";
                break;
            }
            case 13: {
                middle = "/init-upload/";
                break;
            }
            case 15: {
                middle = "/init-toggle/";
                break;
            }
            case 21: {
                middle = "/template-style/";
                break;
            }
            case 22: {
                middle = "/template-toggle/";
                break;
            }
            case 23: {
                middle = "/template-hotTopic/";
                break;
            }
            case 24: {
                middle = "/template-text/";
                break;
            }
            case 100: {
                middle = "/sampling/";
            }
        }
        return middle;
    }

    public static String getFileName(int mode) {
        String fileName = "";
        switch (mode) {
            case 1: {
                fileName = LocalizeUtil.getLocalizeFileName(Const.FAQ_FILE);
                break;
            }
            case 2: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_RPA_PREDICTION);
                break;
            }
            case 11: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_INIT_LOCALE_FILE);
                break;
            }
            case 12: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_INIT_PROCESS);
                break;
            }
            case 14: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_INIT_TEXT);
                break;
            }
            case 13: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_INIT_UPLOAD_LIMIT);
                break;
            }
            case 15: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_INIT_BUSINESS_LOGIC);
                break;
            }
            case 21: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_TEMPLATE_STYLE_SHEET);
                break;
            }
            case 22: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_TEMPLATE_BUSINESS_LOGIC);
                break;
            }
            case 23: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_TEMPLATE_FAQ_HOT_TOPIC);
                break;
            }
            case 24: {
                fileName = LocalizeUtil.getLocalizeFileName(API.CONFIG_TEMPLATE_TEXT);
                break;
            }
            case 100: {
                fileName = LocalizeUtil.getLocalizeFileName(API.SAMPLING_FILTER);
            }
        }
        return fileName;
    }

    private static String getLocalizeFileName(String url) {
        String[] split;
        if (!TextUtils.isEmpty((CharSequence)url) && (split = url.split("/")).length > 0) {
            return split[split.length - 1];
        }
        return String.format("%s-from-api.json", Const.CORRECT_LANGUAGE);
    }
}

