/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.common;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.TLog;
import org.json.JSONObject;

public class UnreadMessagePoller
extends Handler {
    private static UnreadMessagePoller sInstance;
    private static final int POLL_UNREAD_MESSAGE = 100;
    public static final int FETCH_SOURCE_POLL = 1;
    public static final int FETCH_SOURCE_PROACTIVE = 2;
    private long mLastFetchTime;
    private int unreadMessageCount;

    private UnreadMessagePoller() {
    }

    public static UnreadMessagePoller getInstance() {
        if (sInstance == null) {
            sInstance = new UnreadMessagePoller();
        }
        return sInstance;
    }

    public void start() {
        this.stop();
        this.sendEmptyMessage(100);
    }

    public void fetch(int fetchSource) {
        boolean isFetched = this.fetchUnreadMessageCount(fetchSource);
        if (isFetched && fetchSource == 2) {
            this.mLastFetchTime = System.currentTimeMillis();
        }
    }

    public void stop() {
        this.removeCallbacksAndMessages(null);
    }

    public void reset() {
        this.unreadMessageCount = 0;
    }

    public void handleMessage(@NonNull Message msg) {
        this.fetchUnreadMessageCount(1);
        this.sendEmptyMessageDelayed(100, this.getPollingLimit());
    }

    private boolean fetchUnreadMessageCount(final int fetchSource) {
        if (this.interceptFetchRequest(fetchSource)) {
            this.onMessageUnreadCountCallback(fetchSource);
            return false;
        }
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "appid", Const.APP_ID);
        JsonHelper.put(params, "uid", UserProfile.USER_ID);
        AIHelpRequest.getInstance().requestGetByAsync(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                JSONObject jsonObject = JsonHelper.getJsonObject(result);
                Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                int newCount = jsonObject.optInt("cs_message_count");
                int cachedCount = Math.max(0, SpUtil.getInstance().getInt(UserProfile.USER_ID));
                UnreadMessagePoller.this.unreadMessageCount = Math.max(0, newCount - cachedCount);
                UnreadMessagePoller.this.onMessageUnreadCountCallback(fetchSource);
            }
        });
        return true;
    }

    private void onMessageUnreadCountCallback(int fetchSource) {
        switch (fetchSource) {
            case 1: {
                if (Const.sPollingUnreadCountListener == null) break;
                Const.sPollingUnreadCountListener.onMessageCountArrived(this.unreadMessageCount);
                break;
            }
            case 2: {
                if (Const.sFetchingUnreadCountListener == null) break;
                Const.sFetchingUnreadCountListener.onMessageCountArrived(this.unreadMessageCount);
            }
        }
    }

    private boolean interceptFetchRequest(int fetchSource) {
        if (Const.IS_SDK_SHOWING) {
            this.log("[UnreadMessageCount] AIHelp session is visible to user, do not need fetch for unread messages.");
            return true;
        }
        if (!Const.TOGGLE_FETCH_MESSAGE) {
            this.log(String.format("[UnreadMessageCount] Current user(%s) does not have any active tickets at present.", UserProfile.USER_ID));
            return true;
        }
        if (fetchSource == 1 && !this.isPollingEnable()) {
            this.log("[UnreadMessageCount] Unread message count polling is not enabled, please contact AIHelp for more information.");
            return true;
        }
        if (fetchSource == 2 && !this.isProactiveFetchEnable()) {
            this.log(String.format("[UnreadMessageCount] Cached count is returned, the latest data can be obtained in %s seconds.", this.getDelayForNextFetch()));
            return true;
        }
        if (UserProfile.USER_ID.equals(DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()))) {
            this.log("[UnreadMessageCount] The userId you're using is AIHelp's generated deviceId, please verify if this is what you want.");
        }
        return false;
    }

    private void log(String msg) {
        TLog.d("AIHelp", msg);
    }

    private long getPollingLimit() {
        if (BreakReleaseHelper.isBreak()) {
            return 10000L;
        }
        if (!this.isPollingEnable()) {
            return 300000L;
        }
        return (long)Const.LIMIT_CHECKING_UNREAD * 1000L;
    }

    private boolean isPollingEnable() {
        return Const.TOGGLE_OPEN_UNREAD_MSG && Const.LIMIT_CHECKING_UNREAD > 0;
    }

    private boolean isProactiveFetchEnable() {
        return Const.LIMIT_PROACTIVE_FETCH > 0 && System.currentTimeMillis() - this.mLastFetchTime > (long)Const.LIMIT_PROACTIVE_FETCH * 1000L;
    }

    private long getDelayForNextFetch() {
        if (Const.LIMIT_PROACTIVE_FETCH > 0) {
            return (long)Const.LIMIT_PROACTIVE_FETCH - (System.currentTimeMillis() - this.mLastFetchTime) / 1000L;
        }
        return -1L;
    }
}

