/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs;

import android.content.Context;
import android.text.TextUtils;
import java.util.List;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.core.mvp.AbsPresenter;
import net.aihelp.core.mvp.IRepository;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.net.mqtt.AIHelpMqtt;
import net.aihelp.core.net.mqtt.callback.IMqttCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.logic.common.UnreadMessagePoller;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.logic.cs.rpa.helper.HistoryHelper;
import net.aihelp.data.logic.cs.rpa.helper.ResponseHelper;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.TLog;
import net.aihelp.utils.UploadFileHelper;
import org.json.JSONObject;

public class CustomerServicePresenter
extends AbsPresenter<CustomerServiceFragment, IRepository> {
    public CustomerServicePresenter(Context context) {
        super(context, 5);
    }

    public void prepareMqtt(IMqttCallback callback, int connectionType) {
        AIHelpMqtt.getInstance().prepare(callback, connectionType);
    }

    public void requestLogin() {
        JSONObject loginParams = ResponseHelper.getLoginParams();
        EventTracker.INSTANCE.log(303, JsonHelper.getJsonObject(loginParams.toString()));
        this.post(API.LOGIN, loginParams, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                if (CustomerServicePresenter.this.isViewAttached()) {
                    CustomerServicePresenter.this.mRetryHandler.removeCallbacksAndMessages(null);
                    List<Message> loginResponse = ResponseHelper.getLoginResponse(result);
                    Message message = ResponseHelper.getRPAMessage(result);
                    RPAStep lastRpaStep = ResponseHelper.getRPAStep(result);
                    if (TicketStatusTracker.isTicketActive && TicketStatusTracker.isTicketServingByAgent()) {
                        lastRpaStep.setNextStep(100);
                    } else if (TicketStatusTracker.isTicketFinished || TicketStatusTracker.isTicketRejected) {
                        lastRpaStep.setNextStep(102);
                    }
                    ((CustomerServiceFragment)CustomerServicePresenter.this.mView).onLogin(loginResponse, message, lastRpaStep);
                }
            }

            @Override
            public void onFailure(String url, int errorCode, String errorMsg) {
                CustomerServicePresenter.this.mRetryHandler.handleRetryRequest(errorCode, errorMsg);
            }
        });
    }

    public void logout() {
        this.post(API.LOGOUT, null, null);
    }

    public void chatWithSupport(int requestType, final long timestamp, JSONObject chatParams) {
        EventTracker.INSTANCE.log(309, chatParams);
        StatisticTracker.getInstance().setWhenMessageSent();
        this.post(this.getRequestUrl(requestType), chatParams, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                if (CustomerServicePresenter.this.isViewAttached()) {
                    ResponseHelper.notifyMqttPush(result);
                    Message message = ResponseHelper.getRPAMessage(result);
                    RPAStep rpaStep = ResponseHelper.getRPAStep(result);
                    ((CustomerServiceFragment)CustomerServicePresenter.this.mView).updateMessageStatus(true, timestamp, message.getTimestamp() - 1L);
                    if (rpaStep.getNextStep() == 104) {
                        CustomerServicePresenter.this.requestLogin();
                    } else if (rpaStep.isEnableUpload()) {
                        UploadFileHelper.INSTANCE.tryUploadLog(true);
                    } else {
                        if (message.isNormalMessage()) {
                            ((CustomerServiceFragment)CustomerServicePresenter.this.mView).updateChatList(message);
                        }
                        if (rpaStep.getNextStep() != 105) {
                            ((CustomerServiceFragment)CustomerServicePresenter.this.mView).updateBottomLayout(message, rpaStep);
                        }
                    }
                }
                if (!MqttConfig.getInstance().isConnected()) {
                    ApiExecutorFactory.getHandlerExecutor().runAsyncDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (CustomerServicePresenter.this.isViewAttached()) {
                                ((CustomerServiceFragment)CustomerServicePresenter.this.mView).prepareMqtt(2);
                            }
                        }
                    }, 2000L);
                }
            }

            @Override
            public void onFailure(String url, int errorCode, String errorMsg) {
                if (CustomerServicePresenter.this.isViewAttached()) {
                    EventTracker.INSTANCE.log(310, new Object[0]);
                    ((CustomerServiceFragment)CustomerServicePresenter.this.mView).updateMessageStatus(false, timestamp, timestamp);
                }
            }
        });
    }

    private String getRequestUrl(int requestType) {
        switch (requestType) {
            case 2: {
                return API.ASK_FOR_RESOLVE_STATUS;
            }
            case 3: {
                return API.EVALUATE_TICKET;
            }
        }
        return API.SEND_MESSAGE;
    }

    public void goBackToPreviousStep() {
        EventTracker.INSTANCE.log(316, new Object[0]);
        this.get(API.PREVIOUS_STEP, null, new ReqCallback<String>(){

            @Override
            public void onReqSuccess(String result) {
                if (CustomerServicePresenter.this.isViewAttached()) {
                    CustomerServicePresenter.this.cleanMsgListAfterGoBackToPreviousStep(result);
                    Message message = ResponseHelper.getRPAMessage(result);
                    RPAStep rpaStep = ResponseHelper.getRPAStep(result);
                    if (rpaStep.isEnableUpload()) {
                        UploadFileHelper.INSTANCE.tryUploadLog(true);
                    } else if (rpaStep.getNextStep() != 105) {
                        ((CustomerServiceFragment)CustomerServicePresenter.this.mView).updateBottomLayout(message, rpaStep);
                    }
                }
            }
        });
    }

    private void cleanMsgListAfterGoBackToPreviousStep(String prevStepResponse) {
        try {
            if (this.isViewAttached()) {
                JSONObject jsonObject = new JSONObject(prevStepResponse);
                long startTime = jsonObject.optLong("startTime");
                long endTime = jsonObject.optLong("endTime");
                ((CustomerServiceFragment)this.mView).notifyMessageWithdrawn(startTime, endTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void getLastConversation() {
        EventTracker.INSTANCE.log(317, new Object[0]);
        if (!AppInfoUtil.validateNetwork(this.mContext) && this.isViewAttached()) {
            ((CustomerServiceFragment)this.mView).onLastConversationRetrieved(null);
            return;
        }
        try {
            JSONObject hashMap = new JSONObject();
            hashMap.put("userId", (Object)UserProfile.USER_ID);
            hashMap.put("processId", (Object)ProcessEntranceHelper.INSTANCE.getCurrentProcess().getEntranceId());
            hashMap.put("messageTime", TicketStatusTracker.firstMessageTimeStampInList);
            hashMap.put("language", (Object)Const.ORIGINAL_LANGUAGE);
            hashMap.put("pageSize", 20);
            this.get(API.GET_LAST_CONVERSATION, hashMap, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    if (CustomerServicePresenter.this.isViewAttached()) {
                        List<Message> list = HistoryHelper.getHistoryList(result, 2);
                        TicketStatusTracker.setFirstMessageTimeStampInList(list);
                        ((CustomerServiceFragment)CustomerServicePresenter.this.mView).onLastConversationRetrieved(list);
                    }
                }

                @Override
                public void onFailure(String url, int errorCode, String errorMsg) {
                    if (CustomerServicePresenter.this.isViewAttached()) {
                        ((CustomerServiceFragment)CustomerServicePresenter.this.mView).onLastConversationRetrieved(null);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshUnreadMessageCount() {
        try {
            TicketStatusTracker.hasUnreadMsg = false;
            JSONObject params = new JSONObject();
            params.put("appid", (Object)Const.APP_ID);
            params.put("uid", (Object)UserProfile.USER_ID);
            this.get(API.FETCH_NEW_MSG, params, new ReqCallback<String>(){

                @Override
                public void onReqSuccess(String result) {
                    try {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            JSONObject jsonObject = new JSONObject(result);
                            Const.TOGGLE_FETCH_MESSAGE = jsonObject.optBoolean("isHaveChat");
                            int newCount = jsonObject.optInt("cs_message_count");
                            CustomerServicePresenter.this.mSp.put(UserProfile.USER_ID, Math.max(0, newCount));
                            UnreadMessagePoller.getInstance().reset();
                            if (Const.TOGGLE_OPEN_UNREAD_MSG && Const.sPollingUnreadCountListener != null) {
                                Const.sPollingUnreadCountListener.onMessageCountArrived(0);
                            }
                        }
                    }
                    catch (Exception e) {
                        TLog.d("Conversation fetch new msg failed, because " + e.toString());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCachedUnreadMessageCount(boolean isAgentMessage, boolean withdrawMessage) {
        if (isAgentMessage) {
            int cacheCount = this.mSp.getInt(UserProfile.USER_ID, 0);
            this.mSp.put(UserProfile.USER_ID, withdrawMessage ? --cacheCount : ++cacheCount);
        }
    }

    @Override
    public void onRetryRequest() {
        this.requestLogin();
    }

    private boolean isViewAttached() {
        return this.mView != null && !((CustomerServiceFragment)this.mView).isDetached();
    }
}

