/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs;

import androidx.fragment.app.Fragment;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.aihelp.common.API;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.net.mqtt.config.MqttConfig;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.logic.cs.rpa.helper.ResponseHelper;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.helper.BreakReleaseHelper;
import net.aihelp.utils.ListUtil;
import org.json.JSONObject;

public enum MessagePoller {
    INSTANCE;

    public static final int POLL_SOURCE_LOGIN = 1;
    public static final int POLL_SOURCE_FAILURE = 2;
    public static final int POLL_SOURCE_RECONNECT = 3;
    public static final int POLL_SOURCE_SCHEDULER = 4;
    private ScheduledFuture<?> newMessageFetcher;
    private WeakReference<CustomerServiceFragment> csFragment;

    public void startMessagePolling(Fragment fragment) {
        if (fragment instanceof CustomerServiceFragment) {
            this.csFragment = new WeakReference<CustomerServiceFragment>((CustomerServiceFragment)fragment);
        }
        if (BreakReleaseHelper.isBreak()) {
            TicketStatusTracker.ticketPollInterval = 10;
        }
        if (this.newMessageFetcher == null) {
            this.newMessageFetcher = Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (MqttConfig.getInstance().isConnected()) {
                        return;
                    }
                    MessagePoller.this.fetchMessagesSinceLatest(4);
                }
            }, TicketStatusTracker.ticketPollInterval, TicketStatusTracker.ticketPollInterval, TimeUnit.SECONDS);
        }
    }

    public void stopMessagePolling() {
        if (this.newMessageFetcher != null) {
            this.newMessageFetcher.cancel(true);
            this.newMessageFetcher = null;
        }
    }

    public void fetchMessagesSinceLatest(int pollSource) {
        if (TicketStatusTracker.isTicketFinished || TicketStatusTracker.isTicketRejected) {
            return;
        }
        try {
            if (this.csFragment != null && this.csFragment.get() != null) {
                final CustomerServiceFragment customerServiceFragment = (CustomerServiceFragment)this.csFragment.get();
                JSONObject params = new JSONObject();
                params.put("messageTime", customerServiceFragment.getLastAgentMessageTimestamp());
                params.put("pollSource", pollSource);
                params.put("ticketId", (Object)TicketStatusTracker.currentTicketId);
                AIHelpRequest.getInstance().requestGetByAsync(API.POLL_MESSAGE_AFTER_MQTT_DISCONNECT, params, new ReqCallback<String>(){

                    @Override
                    public void onReqSuccess(String result) {
                        List<Message> pollResponse = ResponseHelper.getPollResponse(result);
                        Message message = ResponseHelper.getRPAMessage(result);
                        RPAStep lastRpaStep = ResponseHelper.getRPAStep(result);
                        if (TicketStatusTracker.isTicketActive && TicketStatusTracker.isTicketServingByAgent()) {
                            lastRpaStep.setNextStep(100);
                        } else if (TicketStatusTracker.isTicketFinished || TicketStatusTracker.isTicketRejected) {
                            lastRpaStep.setNextStep(102);
                        }
                        if (!ListUtil.isListEmpty(pollResponse)) {
                            customerServiceFragment.updateChatList(pollResponse, false);
                        }
                        if (!TicketStatusTracker.isTicketServingByAnswerBot() || TicketStatusTracker.isTicketFinished || TicketStatusTracker.isTicketRejected) {
                            customerServiceFragment.updateBottomLayout(message, lastRpaStep, false);
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

