/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs;

import java.util.List;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.utils.ListUtil;

public class TicketStatusTracker {
    public static int TICKET_ASSIGNED_TO_AGENT = 1;
    public static int TICKET_ASSIGNED_TO_RPA_BOT = 2;
    public static int TICKET_UNASSIGNED_WITH_AGENT = 11;
    public static int TICKET_UNASSIGNED_WITH_BOT = 12;
    public static int TICKET_STATUS_FINISHED = 6;
    public static int TICKET_STATUS_REJECTED = 9;
    public static String currentTicketId;
    public static int ticketPollInterval;
    public static long firstMessageTimeStampInList;
    public static boolean isTicketActive;
    public static boolean isTicketFinished;
    public static boolean isTicketRejected;
    public static boolean hasUnreadMsg;
    public static int ticketAssignType;

    public static boolean isTicketServingByNobody() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByAgent() {
        return ticketAssignType == TICKET_ASSIGNED_TO_AGENT || ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByRPA() {
        return ticketAssignType == TICKET_ASSIGNED_TO_RPA_BOT;
    }

    public static boolean isTicketServingByAnswerBot() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_BOT;
    }

    public static void setFirstMessageTimeStampInList(List<Message> msgList) {
        Message message;
        if (!ListUtil.isListEmpty(msgList) && (message = msgList.get(0)) != null) {
            firstMessageTimeStampInList = message.getTimestamp();
        }
    }

    public static void updateAssignTypeWithActiveStatus(boolean isTicketActive, int ticketAssignType) {
        TicketStatusTracker.isTicketActive = isTicketActive;
        hasUnreadMsg = false;
        TicketStatusTracker.ticketAssignType = ticketAssignType;
        if (!isTicketActive) {
            TicketStatusTracker.ticketAssignType = TICKET_UNASSIGNED_WITH_BOT;
        }
    }

    public static void resetTicketStatusFlags() {
        hasUnreadMsg = false;
        isTicketActive = false;
        isTicketFinished = false;
        isTicketRejected = false;
    }

    static {
        ticketPollInterval = 60;
    }
}

