/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs.predict.matching;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.logic.cs.predict.matching.BaseMatching;
import net.aihelp.data.model.faq.FaqListEntity;
import org.json.JSONArray;
import org.json.JSONObject;

public class FaqKeywordsMatching
extends BaseMatching {
    @Override
    public List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query) {
        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();
        ArrayList<FaqListEntity> unorderedList = new ArrayList<FaqListEntity>();
        block0: for (int i = 0; i < sourceFaqs.length(); ++i) {
            String[] keywordsArr;
            String keywords;
            JSONObject faq = JsonHelper.getJsonObject(sourceFaqs, i);
            if (faq.optBoolean("isHidden") || TextUtils.isEmpty((CharSequence)(keywords = faq.optString("keyWords")))) continue;
            for (String keyword : keywordsArr = keywords.split(",")) {
                if (query.toLowerCase().contains(keyword.toLowerCase()) && this.matchedEnough(unorderedList, faq, query)) break block0;
            }
        }
        Collections.sort(unorderedList, new Comparator<FaqListEntity>(){

            @Override
            public int compare(FaqListEntity o1, FaqListEntity o2) {
                return o2.getOrder() - o1.getOrder();
            }
        });
        for (FaqListEntity faqListEntity : unorderedList) {
            this.addWithoutDuplication(matchedList, faqListEntity);
        }
        return this.getMatchingResult(matchedList, query);
    }

    private boolean matchedEnough(List<FaqListEntity> unorderedList, JSONObject faq, String query) {
        String faqMainId = faq.optString("kmMainid");
        String faqTitle = faq.optString("question");
        boolean isInserted = false;
        for (int j = 0; j < unorderedList.size(); ++j) {
            FaqListEntity unorderedFaq = unorderedList.get(j);
            if (!TextUtils.equals((CharSequence)unorderedFaq.getId(), (CharSequence)faqMainId)) continue;
            unorderedFaq.setOrder(unorderedFaq.getOrder() + 1);
            isInserted = true;
            break;
        }
        if (!isInserted) {
            FaqListEntity faqEntity = FaqListEntity.createPrediction(faqMainId, faqTitle, query);
            faqEntity.setOrder(1);
            unorderedList.add(faqEntity);
        }
        return unorderedList.size() == 6;
    }
}

