/*
 * Decompiled with CFR 0.152.
 */
package net.aihelp.data.logic.cs.rpa.factory;

import android.text.TextUtils;
import java.util.regex.Pattern;
import net.aihelp.data.logic.cs.rpa.factory.MessageFactory;
import net.aihelp.data.model.rpa.msg.agent.AgentMessage;
import net.aihelp.data.model.rpa.msg.agent.AgentRichMessage;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;

public class AgentMessageFactory
extends MessageFactory {
    public static Message getAgentMessage(String msg, long timestamp, String nickname) {
        switch (AgentMessageFactory.getAgentMessageType(msg)) {
            case 6: {
                return AgentMessageFactory.getAgentImageMessage(msg, timestamp, nickname);
            }
            case 7: {
                return AgentMessageFactory.getAgentVideoMessage(msg, timestamp, nickname);
            }
            case 9: {
                return AgentMessageFactory.getAgentFileMessage(msg, timestamp, nickname);
            }
            case 8: {
                return AgentMessageFactory.getAgentRichTextMessage(msg, timestamp, nickname);
            }
        }
        return AgentMessageFactory.getAgentTextMessage(msg, timestamp, nickname);
    }

    private static int getAgentMessageType(String message) {
        if (AgentMessageFactory.isAgentImage(message)) {
            return 6;
        }
        if (AgentMessageFactory.isAgentVideo(message)) {
            return 7;
        }
        if (AgentMessageFactory.isAgentAttachment(message)) {
            return 9;
        }
        if (AgentMessageFactory.isAgentRichText(message)) {
            return 8;
        }
        return 3;
    }

    private static Message getAgentTextMessage(String msg, long timestamp, String nickname) {
        AgentMessage agentMessage = new AgentMessage(nickname);
        agentMessage.setTimestamp(timestamp);
        agentMessage.setContent(AgentMessageFactory.getPeeledContent(msg));
        agentMessage.setNormalMessage(true);
        return agentMessage;
    }

    private static Message getAgentRichTextMessage(String message, long timestamp, String nickname) {
        AgentRichMessage agentRichMessage = new AgentRichMessage(nickname);
        agentRichMessage.setTimestamp(timestamp);
        agentRichMessage.setNormalMessage(true);
        agentRichMessage.setMessageList(message);
        return agentRichMessage;
    }

    private static Message getAgentImageMessage(String msg, long timestamp, String nickname) {
        FileMessage imageMsg = new FileMessage(6, AgentMessageFactory.getPeeledContent(msg));
        if (AgentMessageFactory.isAgentAttachment(msg)) {
            imageMsg = AgentMessageFactory.getAttachmentMessage(msg, 6);
        }
        imageMsg.setTimestamp(timestamp);
        imageMsg.setNickname(nickname);
        imageMsg.setNormalMessage(true);
        return imageMsg;
    }

    private static Message getAgentVideoMessage(String msg, long timestamp, String nickname) {
        FileMessage videoMsg = new FileMessage(7, AgentMessageFactory.getPeeledContent(msg));
        if (AgentMessageFactory.isAgentAttachment(msg)) {
            videoMsg = AgentMessageFactory.getAttachmentMessage(msg, 7);
        }
        videoMsg.setTimestamp(timestamp);
        videoMsg.setNickname(nickname);
        videoMsg.setNormalMessage(true);
        return videoMsg;
    }

    private static Message getAgentFileMessage(String msg, long timestamp, String nickname) {
        FileMessage fileMessage = AgentMessageFactory.getAttachmentMessage(msg, 9);
        fileMessage.setNickname(nickname);
        fileMessage.setTimestamp(timestamp);
        fileMessage.setNormalMessage(true);
        return fileMessage;
    }

    private static boolean isAgentText(String message) {
        return !TextUtils.isEmpty((CharSequence)AgentMessageFactory.getPeeledContent(message));
    }

    private static boolean isAgentImage(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(png|jpg|jpeg|gif)").matcher(AgentMessageFactory.getPeeledContent(message)).matches() || AgentMessageFactory.isAttachmentImage(message);
    }

    private static boolean isAgentVideo(String message) {
        return Pattern.compile("(?i)(http:|https:)(//)((?!\").)*?\\.(mp4|3gp|mkv|webm)").matcher(AgentMessageFactory.getPeeledContent(message)).matches() || AgentMessageFactory.isAttachmentVideo(message);
    }

    private static boolean isAgentRichText(String message) {
        String replyContent = AgentMessageFactory.getPeeledContent(message);
        boolean replyWithHyperLinks = Pattern.compile("(?i)(https?://\\S*?((?=\\s+http)|\\.(png|jpg|jpeg|gif|mp4|3gp|mkv|webm))|https?://((?!\").)*)").matcher(replyContent).find();
        boolean replyWithAttachment = !TextUtils.isEmpty((CharSequence)replyContent) && AgentMessageFactory.hasAtLeastNAttachments(message, 1);
        boolean multipleAttachments = TextUtils.isEmpty((CharSequence)replyContent) && AgentMessageFactory.hasAtLeastNAttachments(message, 2);
        return replyWithHyperLinks || replyWithAttachment || multipleAttachments;
    }

    private static boolean isAgentAttachment(String message) {
        return TextUtils.isEmpty((CharSequence)AgentMessageFactory.getPeeledContent(message)) && AgentMessageFactory.hasOnlyOneAttachment(message);
    }
}

